# Optimized Python Code
# Archivo: DMbreakersSQL.py
# Ruta: src\Consultas_SQL\SupYCtrol\GerenteSyC\GSYCDES_Reporte_financiero_OVSQL.py
# Lenguaje: Python
from Consultas_SQL.conexion import get_connectionbdproductivo
def get_Consulta():
    """Obtiene los Breakers desde la base de datos."""
    query = """
    SELECT 
        isnull (DES_Reporte_financiero_OV.Company, '')as Company,
        isnull (DES_Reporte_financiero_OV.OV, '')as OV,
        isnull (DES_Reporte_financiero_OV.FechaOV, '')as FechaOV,
        isnull (DES_Reporte_financiero_OV.OrderCode, '')as OrderCode,
        isnull (DES_Reporte_financiero_OV.División, '')as División,
        isnull (DES_Reporte_financiero_OV.Clasificación, '')as Clasificación,
        isnull (DES_Reporte_financiero_OV.Departamento, '')as Departamento,
        isnull (DES_Reporte_financiero_OV.DepartamentClass, '')as DepartamentClass,
        isnull (DES_Reporte_financiero_OV.Vendedor, '')as Vendedor,
        isnull (DES_Reporte_financiero_OV.CustNum, '')as CustNum,
        isnull (DES_Reporte_financiero_OV.CustID, '')as CustID,
        isnull (DES_Reporte_financiero_OV.Cliente, '')as Cliente,
        isnull (DES_Reporte_financiero_OV.TotalLines, '')as TotalLines,
        isnull (DES_Reporte_financiero_OV.EstatusOV, '')as EstatusOV,
        isnull (DES_Reporte_financiero_OV. Importe , '')as  Importe ,
        isnull (DES_Reporte_financiero_OV. Descuento , '')as  Descuento ,
        isnull (DES_Reporte_financiero_OV. [Misc.] , '')as  [Misc.] ,
        isnull (DES_Reporte_financiero_OV. Subtotal , '')as  Subtotal ,
        isnull (DES_Reporte_financiero_OV. Impuesto , '')as  Impuesto ,
        isnull (DES_Reporte_financiero_OV. Redondeo , '')as  Redondeo ,
        isnull (DES_Reporte_financiero_OV. [Total de la Orden] , '')as  [Total de la Orden] ,
        isnull (DES_Reporte_financiero_OV.Moneda, '')as Moneda,
        isnull (DES_Reporte_financiero_OV. Cambio , '')as  Cambio ,
        isnull (DES_Reporte_financiero_OV. ImporteMXN , '')as  ImporteMXN ,
        isnull (DES_Reporte_financiero_OV. DescuentoMXN , '')as  DescuentoMXN ,
        isnull (DES_Reporte_financiero_OV. [Misc.MXN] , '')as  [Misc.MXN] ,
        isnull (DES_Reporte_financiero_OV. SubtotalMXN , '')as  SubtotalMXN ,
        isnull (DES_Reporte_financiero_OV. ImpuestoMXN , '')as  ImpuestoMXN ,
        isnull (DES_Reporte_financiero_OV. RedondeoMXN , '')as  RedondeoMXN ,
        isnull (DES_Reporte_financiero_OV. [Total de la Orden MXN] , '')as  [Total de la Orden MXN] ,
        isnull (DES_Reporte_financiero_OV.[Terminos OV], '')as [Terminos OV],
        isnull (DES_Reporte_financiero_OV.[Dias de pago OV], '')as [Dias de pago OV],
        isnull (DES_Reporte_financiero_OV.[Comentario de OV], '')as [Comentario de OV],
        isnull (DES_Reporte_financiero_OV.TipoDeVenta, '')as TipoDeVenta,
        isnull (DES_Reporte_financiero_OV. Facturado , '')as  Facturado ,
        isnull (DES_Reporte_financiero_OV. FacturadoIVA , '')as  FacturadoIVA ,
        isnull (DES_Reporte_financiero_OV. FacturadoMXN , '')as  FacturadoMXN ,
        isnull (DES_Reporte_financiero_OV. FacturadoIVAMXN , '')as  FacturadoIVAMXN ,
        isnull (DES_Reporte_financiero_OV.ListaDeFacturas, '')as ListaDeFacturas,
        isnull (DES_Reporte_financiero_OV.FechaUltimaFactura, '')as FechaUltimaFactura,
        isnull (DES_Reporte_financiero_OV. [Facturacion Manual] , '')as  [Facturacion Manual] ,
        isnull (DES_Reporte_financiero_OV.[Comentario de correccion], '')as [Comentario de correccion],
        isnull (DES_Reporte_financiero_OV. [Por Facturar] , '')as  [Por Facturar] ,
        isnull (DES_Reporte_financiero_OV.[%], '')as [%],
        isnull (DES_Reporte_financiero_OV. Revisión , '')as  Revisión ,
        isnull (DES_Reporte_financiero_OV.AllProjectID, '')as AllProjectID,
        isnull (DES_Reporte_financiero_OV.Columna1, '')as Columna1,
        isnull (DES_Reporte_financiero_OV.JobNumsInProject, '')as JobNumsInProject,
        isnull (DES_Reporte_financiero_OV. Material , '')as  Material ,
        isnull (DES_Reporte_financiero_OV. Labor , '')as  Labor ,
        isnull (DES_Reporte_financiero_OV. Burden , '')as  Burden ,
        isnull (DES_Reporte_financiero_OV. Subcontract , '')as  Subcontract ,
        isnull (DES_Reporte_financiero_OV. MtlBur , '')as  MtlBur ,
        isnull (DES_Reporte_financiero_OV. TotalCostPrj , '')as  TotalCostPrj ,
        isnull (DES_Reporte_financiero_OV.JobNumsDirectOV, '')as JobNumsDirectOV,
        isnull (DES_Reporte_financiero_OV. MaterialDir , '')as  MaterialDir ,
        isnull (DES_Reporte_financiero_OV. LaborDir , '')as  LaborDir ,
        isnull (DES_Reporte_financiero_OV. BurdenDir , '')as  BurdenDir ,
        isnull (DES_Reporte_financiero_OV. SubcontractDir , '')as  SubcontractDir ,
        isnull (DES_Reporte_financiero_OV. MtlBurDir , '')as  MtlBurDir ,
        isnull (DES_Reporte_financiero_OV. TotalCostDir , '')as  TotalCostDir ,
        isnull (DES_Reporte_financiero_OV.TotalCost, '')as TotalCost,
        isnull (DES_Reporte_financiero_OV.Utilidad, '')as Utilidad,
        isnull (DES_Reporte_financiero_OV.[%2], '')as [%2]

    FROM
        DES_Reporte_financiero_OV
    """
    try:
        conn = get_connectionbdproductivo()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query)
        results = cursor.fetchall()
        
        return [
            {
                "Company": row[0],
                "OV": row[1],
                "FechaOV": row[2],
                "OrderCode": row[3],
                "División": row[4],
                "Clasificación": row[5],
                "Departamento": row[6],
                "DepartamentClass": row[7],
                "Vendedor": row[8],
                "CustNum": row[9],
                "CustID": row[10],
                "Cliente": row[11],
                "TotalLines": row[12],
                "EstatusOV": row[13],
                "Importe": row[14],
                "Descuento": row[15],
                "Misc": row[16],
                "Subtotal": row[17],
                "Impuesto": row[18],
                "Redondeo": row[19],
                "Total_de_la_Orden": row[20],
                "Moneda": row[21],
                "Cambio": row[22],
                "ImporteMXN": row[23],
                "DescuentoMXN": row[24],
                "MiscMXN": row[25],
                "SubtotalMXN": row[26],
                "ImpuestoMXN": row[27],
                "RedondeoMXN": row[28],
                "Total_de_la_Orden_MXN": row[29],
                "Terminos_OV": row[30],
                "Dias_de_pago_OV": row[31],
                "Comentario_de_OV": row[32],
                "TipoDeVenta": row[33],
                "Facturado": row[34],
                "FacturadoIVA": row[35],
                "FacturadoMXN": row[36],
                "FacturadoIVAMXN": row[37],
                "ListaDeFacturas": row[38],
                "FechaUltimaFactura": row[39],
                "Facturacion_Manual": row[40],
                "Comentario_de_correccion": row[41],
                "Por_Facturar": row[42],
                "porcentage": row[43],
                "Revisión": row[44],
                "AllProjectID": row[45],
                "Columna1": row[46],
                "JobNumsInProject": row[47],
                "Material": row[48],
                "Labor": row[49],
                "Burden": row[50],
                "Subcontract": row[51],
                "MtlBur": row[52],
                "TotalCostPrj": row[53],
                "JobNumsDirectOV": row[54],
                "MaterialDir": row[55],
                "LaborDir": row[56],
                "BurdenDir": row[57],
                "SubcontractDir": row[58],
                "MtlBurDir": row[59],
                "TotalCostDir": row[60],
                "TotalCost": row[61],
                "Utilidad": row[62],
                "porcentage2": row[63]
            } for row in results]
    except Exception as e:
        print(f"[Error inesperado] Error obteniendo breakers: {e}")
        return []
    finally:
        if conn:
            conn.close()
            



