# Optimized Python Code
# Archivo: DMbreakersSQL.py
# Ruta: src\Consultas_SQL\SupYCtrol\GerenteSyC\GSYCReporte_financiero_ContratosSQL.py
# Lenguaje: Python
from Consultas_SQL.conexion import get_connectionbdproductivo
def get_Consulta():
    """Obtiene los Breakers desde la base de datos."""
    query = """
    SELECT 
           isnull (DES_Reporte_financiero_Cont.ContractNum, '')as ContractNum,
    isnull (DES_Reporte_financiero_Cont.EntryDate, '')as EntryDate,
    isnull (DES_Reporte_financiero_Cont.EntryPerson, '')as EntryPerson,
    isnull (DES_Reporte_financiero_Cont.Folio, '')as Folio,
    isnull (DES_Reporte_financiero_Cont.ContractCode, '')as ContractCode,
    isnull (DES_Reporte_financiero_Cont.Division, '')as Division,
    isnull (DES_Reporte_financiero_Cont.Clasificación, '')as Clasificación,
    isnull (DES_Reporte_financiero_Cont.Departamento, '')as Departamento,
    isnull (DES_Reporte_financiero_Cont.DepartamentClass, '')as DepartamentClass,
    isnull (DES_Reporte_financiero_Cont.ContractDescription, '')as ContractDescription,
    isnull (DES_Reporte_financiero_Cont.CustNum, '')as CustNum,
    isnull (DES_Reporte_financiero_Cont.CustID, '')as CustID,
    isnull (DES_Reporte_financiero_Cont.Cliente, '')as Cliente,
    isnull (DES_Reporte_financiero_Cont.Importe, '')as Importe,
    isnull (DES_Reporte_financiero_Cont.ImporteMXN, '')as ImporteMXN,
    isnull (DES_Reporte_financiero_Cont.CurrencyCode, '')as CurrencyCode,
    isnull (DES_Reporte_financiero_Cont.ExchangeRate, '')as ExchangeRate,
    isnull (DES_Reporte_financiero_Cont.Duration, '')as Duration,
    isnull (DES_Reporte_financiero_Cont.Modifier, '')as Modifier,
    isnull (DES_Reporte_financiero_Cont.ActiveDate, '')as ActiveDate,
    isnull (DES_Reporte_financiero_Cont.ExpireDate, '')as ExpireDate,
    isnull (DES_Reporte_financiero_Cont.ContractComment, '')as ContractComment,
    isnull (DES_Reporte_financiero_Cont.InvoiceComment, '')as InvoiceComment,
    isnull (DES_Reporte_financiero_Cont.TipoDeContrato, '')as TipoDeContrato,
    isnull (DES_Reporte_financiero_Cont.Facturado, '')as Facturado,
    isnull (DES_Reporte_financiero_Cont.FacturadoIVA, '')as FacturadoIVA,
    isnull (DES_Reporte_financiero_Cont.FacturadoIVAMXN, '')as FacturadoIVAMXN,
    isnull (DES_Reporte_financiero_Cont.ListaDeFacturas, '')as ListaDeFacturas

    FROM
        DES_Reporte_financiero_Cont
    """
    try:
        conn = get_connectionbdproductivo()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query)
        results = cursor.fetchall()
        
        return [
            {
                "ContractNum": row[0],
                "EntryDate": row[1],
                "EntryPerson": row[2],
                "Folio": row[3],
                "ContractCode": row[4],
                "Division": row[5],
                "Clasificación": row[6],
                "Departamento": row[7],
                "DepartamentClass": row[8],
                "ContractDescription": row[9],
                "CustNum": row[10],
                "CustID": row[11],
                "Cliente": row[12],
                "Importe": row[13],
                "ImporteMXN": row[14],
                "CurrencyCode": row[15],
                "ExchangeRate": row[16],
                "Duration": row[17],
                "Modifier": row[18],
                "ActiveDate": row[19],
                "ExpireDate": row[20],
                "ContractComment": row[21],
                "InvoiceComment": row[22],
                "TipoDeContrato": row[23],
                "Facturado": row[24],
                "FacturadoIVA": row[25],
                "FacturadoIVAMXN": row[26],
                "ListaDeFacturas": row[27]
            } for row in results]
    except Exception as e:
        print(f"[Error inesperado] Error obteniendo breakers: {e}")
        return []
    finally:
        if conn:
            conn.close()
            



