# Optimized Python Code
# Archivo: DMbreakersSQL.py
# Ruta: src\Consultas_SQL\SupYCtrol\DataMaster\Tablas\SYCTabla1SQL.py
# Lenguaje: Python
from Consultas_SQL.conexion import get_connectionbdproductivo
def get_breakers():
    """Obtiene los Breakers desde la base de datos."""
    query = """
    SELECT
        PronFlujo_Contratos.ContractNum,
        PronFlujo_Contratos.EntryDate,
        PronFlujo_Contratos.EntryPerson,
        PronFlujo_Contratos.Folio,
        PronFlujo_Contratos.ContractCode,
        PronFlujo_Contratos.Division,
        PronFlujo_Contratos.Departamento,
        PronFlujo_Contratos.ContractDescription,
        PronFlujo_Contratos.CustNum,
        PronFlujo_Contratos.CustID,
        PronFlujo_Contratos.Cliente,
        PronFlujo_Contratos.Importe,
        PronFlujo_Contratos.ImporteMXN,
        PronFlujo_Contratos.CurrencyCode,
        PronFlujo_Contratos.ExchangeRate,
        PronFlujo_Contratos.Duration,
        PronFlujo_Contratos.Modifier,
        PronFlujo_Contratos.ActiveDate,
        PronFlujo_Contratos.ExpireDate,
        PronFlujo_Contratos.ContractComment,
        PronFlujo_Contratos.InvoiceComment,
        PronFlujo_Contratos.TipoDeContrato,
        PronFlujo_Contratos.Facturado,
        PronFlujo_Contratos.FacturadoIVA,
        PronFlujo_Contratos.FacturadoMXN,
        PronFlujo_Contratos.FacturadoIVAMXN,
        PronFlujo_Contratos.ListaDeFacturas,
        PronFlujo_Contratos.PorFacturar,
        PronFlujo_Contratos.Revisión,
        PronFlujo_Contratos.RevisiónRenovacion,
        PronFlujo_Contratos.[Renovación(si/no)],
        PronFlujo_Contratos.Consideración,
        PronFlujo_Contratos.Comentario,
        PronFlujo_Contratos.Pronostico,
        PronFlujo_Contratos.FechadeCobro

    FROM
        PronFlujo_Contratos
    """
    try:
        conn = get_connectionbdproductivo()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query)
        results = cursor.fetchall()
        
        return [
            {
                "ContractNum": row[0],
                "EntryDate": row[1],
                "EntryPerson": row[2],
                "Folio": row[3],
                "ContractCode": row[4],
                "Division": row[5],
                "Departamento": row[6],
                "ContractDescription": row[7],
                "CustNum": row[8],
                "CustID": row[9],
                "Cliente": row[10],
                "Importe": row[11],
                "ImporteMXN": row[12],
                "CurrencyCode": row[13],
                "ExchangeRate": row[14],
                "Duration": row[15],
                "Modifier": row[16],
                "ActiveDate": row[17],
                "ExpireDate": row[18],
                "ContractComment": row[19],
                "InvoiceComment": row[20],
                "TipoDeContrato": row[21],
                "Facturado": row[22],
                "FacturadoIVA": row[23],
                "FacturadoMXN": row[24],
                "FacturadoIVAMXN": row[25],
                "ListaDeFacturas": row[26],
                "PorFacturar": row[27],
                "Revisión": row[28],
                "RevisiónRenovacion": row[29],
                "Renovación_si_no": row[30],
                "Consideración": row[31],
                "Comentario": row[32],
                "Pronostico": row[33],
                "FechadeCobro": row[34]
            } for row in results]
    except Exception as e:
        print(f"[Error inesperado] Error obteniendo breakers: {e}")
        return []
    finally:
        if conn:
            conn.close()
            



