"""
Archivo: ScoreDistributorsMXSQL.py
Ruta: src\Consultas_SQL\Ventas\VentasDist\ScoreDistributorsMXSQL.py
Descripción: Módulo para crear las funciones del area de Clientes
Autor: Equipo de Desarrollo IGSA
Fecha: 2025
"""


import pyodbc
import logging
from datetime import datetime
from typing import Dict, List, Optional, Union

# Configurar logging
logger = logging.getLogger('Score_DistributorsMX_sql')

from config import Productivo, ENVIRONMENT
from Consultas_SQL.conexion import get_connectionbdproductivo, get_connection, get_connectionERP




# Dependiendo del entorno, se selecciona la función de conexión adecuada
if Productivo:
    ConexionBD_VPS = get_connection
else:
    ConexionBD_VPS = get_connection

ConexionBD_ERP = get_connectionERP


def buscar_score_distributors_view() -> Optional[List[Dict]]:
    """
    
    """

    query = """
                
        SELECT
            Score.OrderNum,
            Score.Tipo,
            Score.Departamento,
            Score.Vendedor,
            Score.Name,
            Score.Capacidad,
            Score.OrderDate,
            Score.NeedByDate,
            Score.FechaPlaneación,
            Score.FechaVentas,
            Score.Faltante_M,
            Score.Estatus_M,
            Score.Fecha_Llegada_M,
            Score.Estatus_G,
            Score.Faltante_G,
            Score.Fecha_Llegada_G
        FROM 
            Score 
        WHERE
            Score.Departamento = 'Distribuidores'  
"""

    conn = None

    try:
        # Obtener la conexión
        conn = ConexionBD_VPS()
        if not conn :
            raise ConnectionError("No se pudo establecer conexión con la base de datos")

        with conn:
            cursor = conn.cursor()
            cursor.execute(query)

            # Obtener los nombres de las columnas
            columns = [column[0] for column in cursor.description]

            #Obtener todos los resultaados
            rows = cursor.fetchall()

            if rows:
                results = []
                for row in rows:
                    result = dict(zip(columns, row))

                    # Convertir a datetume a string para JSON Serelaization
                    for date_field in ['CreatedAt', 'UpdatedAt']:
                        if date_field in result and result[date_field]:
                            result[date_field] = result[date_field].isoformat()

                    results.append(result)

                logger.info(f"Se encontraron {len(results)} registros de score")
                return results
            else:
                 # Log cuando no se encuentra el score
                logger.warning("No se encontraron registros en la tabla Score")
                return None
    except pyodbc.Error as e:
        error_msg = f"Error de base de datos al buscar los scores: {str(e)}"
        logger.error(error_msg)
        raise Exception(error_msg)
    
    except ConnectionError as e:
        error_msg = f"Error de conexión al buscar los scores: {str(e)}"
        logger.error(error_msg)
        raise Exception(error_msg)
    
    except Exception as e:
        error_msg = f"Error inesperado al buscar los scores: {str(e)}"
        logger.error(error_msg)
        raise Exception(error_msg)
    
    finally:
        # Asegurar que la conexión se cierra
        if conn:
            try:
                conn.close()
            except Exception:
                logger.warning("Error al cerrar la conexión ala BD")


