# Archivo: DMAddAccesory_OptionSQL.py
# Ruta: src\Consultas_SQL\Ventas\VentasEUA\DataMaster\DMAddAccesory_OptionSQL.py
# Lenguaje: Python

from Consultas_SQL.conexion import get_connection
def get_AddAccesory_Option():
    """Obtiene los Breakers desde la base de datos."""
    query = """
    SELECT
        CZE_AddAccesory_Option.Item_AddAccesory_option, 
        CZE_AddAccesory_Option.description, 
        CZE_AddAccesory_Option.price, 
        CZE_AddAccesory_Option.TechnicalSheet
    FROM
        CZE_AddAccesory_Option
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query)
        results = cursor.fetchall()
        
        return [{"Item_AddAccesory_option": row[0], "description": row[1], "price": row[2], "TechnicalSheet": row[3]} for row in results]
    except Exception as e:
        print(f"[Error inesperado] Error obteniendo Catálogo de accesorios adicionales de la planta de emergencia: {e}")
        return []
    finally:
        if conn:
            conn.close()
            

def item_exists(item):
    conn = get_connection()
    try:  # Es una buena práctica usar un bloque try...finally para asegurar que la conexión se cierre.
        cursor = conn.cursor()
        cursor.execute("SELECT COUNT(*) FROM CZE_AddAccesory_Option WHERE Item_AddAccesory_option = ?", (item,))
        result = cursor.fetchone()
        return result
    finally: # Esta parte es importante para cerrar la conexión sin importar si hay un error o no
        if conn:
            conn.close()

         
def update_AddAccesory_Option(item, price):
    """Actualiza un Catálogo de accesorios adicionales de la planta de emergencia  en la base de datos."""
    query = """
    UPDATE CZE_AddAccesory_Option
    SET  price = ?
    WHERE Item_AddAccesory_option = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, ( price,item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando Catálogo de accesorios adicionales de la planta de emergencia : {e}")
    finally:
        if conn:
            conn.close()
            

def searchitems():
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        cursor = conn.cursor()
        cursor.execute("SELECT Item_AddAccesory_option,TechnicalSheet from CZE_AddAccesory_Option ")
        results = cursor.fetchall()
        if not results:  # Verifica si la tabla está vacía
            return []  # Devuelve una lista vacía si no hay datos
        return [{"Item_AddAccesory_option": row[0], "TechnicalSheet": row[1]} for row in results]
        
    except Exception as e:
        print(f"[Error inesperado] Error eliminando Catálogo de accesorios adicionales de la planta de emergencia : {e}")
        return []
    finally:
        if conn:
            conn.close()

def update_AddAccesory_Option_TechnicalSheet(item,TechnicalSheet):
    """Actualiza un Catálogo de accesorios adicionales de la planta de emergencia  en la base de datos."""
    query = """
    UPDATE CZE_AddAccesory_Option
    SET TechnicalSheet = ?
    WHERE Item_AddAccesory_option = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (TechnicalSheet,item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando Catálogo de accesorios adicionales de la planta de emergencia : {e}")
    finally:
        if conn:
            conn.close()