# Optimized Python Code
# Archivo: DMAddAccesory_SpringSQL.py
# Ruta: src\Consultas_SQL\Ventas\VentasEUA\DataMaster\DMAddAccesory_SpringSQL.py
# Lenguaje: Python


from Consultas_SQL.conexion import get_connection
def get_Catalogo_de_amortiguadores():
    """Obtiene catalogo de controles desde la base de datos."""
    query = """
     SELECT
        CZE_AddAccesory_Spring.Item_AddAccesory_Spring, 
        CZE_AddAccesory_Spring.description, 
        CZE_AddAccesory_Spring.price, 
        CZE_AddAccesory_Spring.TechnicalSheet
    FROM
        CZE_AddAccesory_Spring
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query)
        results = cursor.fetchall()
        
        # Aseguramos que las claves del diccionario coincidan con las usadas en el JavaScript
        return [{"Item_AddAccesory_Spring": row[0], "description": row[1], "price": row[2], "TechnicalSheet": row[3]} for row in results]
    except Exception as e:
        print(f"[Error inesperado] Error obteniendo Catálogo de amortiguadores : {e}")
        return []
    finally:
        if conn:
            conn.close()
            

def item_exists(item):
    conn = get_connection()
    try:
        cursor = conn.cursor()
        cursor.execute("SELECT COUNT(*) FROM CZE_AddAccesory_Spring WHERE Item_AddAccesory_Spring = ?", (item,))
        result = cursor.fetchone()
        return result
    finally:
        if conn:
            conn.close()

def insert_Catalogo_de_amortiguadores(item, description, price, technicalSheet):
    """Inserta un nuevo Catálogo de amortiguadores en la base de datos."""
    query = """
    INSERT INTO CZE_AddAccesory_Spring (Item_AddAccesory_Spring, description, price,TechnicalSheet)
    VALUES (?, ?, ?, ?)
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (item, description, price, technicalSheet))
        
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error insertando Catálogo de amortiguadores  : {e}")
    finally:
        if conn:
            conn.close()
            
def update_Catalogo_de_amortiguadores(item, description, price):
    """Actualiza un Catálogo de amortiguadores  en la base de datos."""
    query = """
    UPDATE CZE_AddAccesory_Spring
    SET description = ?, price = ?
    WHERE Item_AddAccesory_Spring = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (description, price, item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando Catálogo de amortiguadores  : {e}")
    finally:
        if conn:
            conn.close()
            
def delete_Catalogo_de_amortiguadores(item):
    """Elimina un Catálogo de amortiguadores de la base de datos."""
    query = """
    DELETE FROM CZE_AddAccesory_Spring
    WHERE Item_AddAccesory_Spring = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (item,))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error eliminando el Control: {e}")
    finally:
        if conn:
            conn.close()

def searchitems():
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        cursor = conn.cursor()
        cursor.execute("SELECT Item_AddAccesory_Spring, TechnicalSheet from CZE_AddAccesory_Spring")
        results = cursor.fetchall()
        if not results:  # Verifica si la tabla está vacía
            return []  # Devuelve una lista vacía si no hay datos
        return [{"Item_AddAccesory_Spring": row[0], "TechnicalSheet": row[1]} for row in results]
        
    except Exception as e:
        print(f"[Error inesperado] Error consultando Catálogo de amortiguadores : {e}")
        return []
    finally:
        if conn:
            conn.close()

def update_Catalogo_de_amortiguadores_TechnicalSheet(item, TechnicalSheet):
    """Actualiza la ficha técnica de un Catálogo de amortiguadores en la base de datos."""
    query = """
    UPDATE CZE_AddAccesory_Spring
    SET TechnicalSheet = ?
    WHERE Item_AddAccesory_Spring = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (TechnicalSheet, item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando ficha técnica: {e}")
    finally:
        if conn:
            conn.close()