# Optimized Python Code
# Archivo: DMBreakerProtectionTypeSQL.py
# Ruta: src\Consultas_SQL\Ventas\VentasEUA\DataMaster\DMBreakerProtectionTypeSQL.py
# Lenguaje: Python


from Consultas_SQL.conexion import get_connection
def get_BreakerProtectionType():
    """Obtiene los Breakers desde la base de datos."""
    query = """
     SELECT
        CZE_BreakerProtectionType.Item_breaker_Protection, 
        CZE_BreakerProtectionType.description, 
        CZE_BreakerProtectionType.price, 
        CZE_BreakerProtectionType.TypeBreaker,
        CZE_BreakerProtectionType.TechnicalSheet
    FROM
        CZE_BreakerProtectionType
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query)
        results = cursor.fetchall()
        
        # Aseguramos que las claves del diccionario coincidan con las usadas en el JavaScript
        return [{"Item_breaker_Protection": row[0], "description": row[1], "price": row[2], "TypeBreaker": row[3], "TechnicalSheet": row[4]} for row in results]
    except Exception as e:
        print(f"[Error inesperado] Error obteniendo Catálogo de tipos de protección de interruptores: {e}")
        return []
    finally:
        if conn:
            conn.close()
            

def item_exists(item):
    conn = get_connection()
    try:
        cursor = conn.cursor()
        cursor.execute("SELECT COUNT(*) FROM CZE_BreakerProtectionType WHERE Item_breaker_Protection = ?", (item,))
        result = cursor.fetchone()
        return result
    finally:
        if conn:
            conn.close()

def insert_BreakerProtectionType(item, description, price, type, technicalSheet):
    """Inserta un nuevo breaker en la base de datos."""
    query = """
    INSERT INTO CZE_BreakerProtectionType (Item_breaker_Protection, description, price, TypeBreaker, TechnicalSheet)
    VALUES (?, ?, ?, ?, ?)
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (item, description, price, type, technicalSheet))
        
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error insertando Catálogo de tipos de protección de interruptores: {e}")
    finally:
        if conn:
            conn.close()
            
def update_BreakerProtectionType(item, description, price, type):
    """Actualiza un breaker en la base de datos."""
    query = """
    UPDATE CZE_BreakerProtectionType
    SET description = ?, price = ?, TypeBreaker = ?
    WHERE Item_breaker_Protection = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (description, price, type, item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando Catálogo de tipos de protección de interruptores: {e}")
    finally:
        if conn:
            conn.close()
            
def delete_BreakerProtectionType(item):
    """Elimina un breaker de la base de datos."""
    query = """
    DELETE FROM CZE_BreakerProtectionType
    WHERE Item_breaker_Protection = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (item,))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error eliminando Catálogo de tipos de protección de interruptores: {e}")
    finally:
        if conn:
            conn.close()

def searchitems():
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        cursor = conn.cursor()
        cursor.execute("SELECT Item_breaker_Protection, TechnicalSheet from CZE_BreakerProtectionType")
        results = cursor.fetchall()
        if not results:  # Verifica si la tabla está vacía
            return []  # Devuelve una lista vacía si no hay datos
        return [{"Item_breaker_Protection": row[0], "TechnicalSheet": row[1]} for row in results]
        
    except Exception as e:
        print(f"[Error inesperado] Error consultando Catálogo de tipos de protección de interruptores: {e}")
        return []
    finally:
        if conn:
            conn.close()

def update_BreakerProtectionType_TechnicalSheet(item, TechnicalSheet):
    """Actualiza la ficha técnica de un breaker en la base de datos."""
    query = """
    UPDATE CZE_BreakerProtectionType
    SET TechnicalSheet = ?
    WHERE Item_breaker_Protection = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (TechnicalSheet, item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando ficha técnica: {e}")
    finally:
        if conn:
            conn.close()