# Optimized Python Code
# Archivo: DMControllerBattChargerSQL.py
# Ruta: src\Consultas_SQL\Ventas\VentasEUA\DataMaster\DMControllerBattChargerSQL.py
# Lenguaje: Python


from Consultas_SQL.conexion import get_connection
def get_Catalogo_de_cargadores_de_baterias():
    """Obtiene catalogo de controles desde la base de datos."""
    query = """
     SELECT
        CZE_ControllerBattCharger.Item_batterycharger, 
        CZE_ControllerBattCharger.description, 
        CZE_ControllerBattCharger.price, 
        CZE_ControllerBattCharger.TechnicalSheet
    FROM
        CZE_ControllerBattCharger
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query)
        results = cursor.fetchall()
        
        # Aseguramos que las claves del diccionario coincidan con las usadas en el JavaScript
        return [{"Item_batterycharger": row[0], "description": row[1], "price": row[2], "TechnicalSheet": row[3]} for row in results]
    except Exception as e:
        print(f"[Error inesperado] Error obteniendo Catálogo de cargadores de baterías : {e}")
        return []
    finally:
        if conn:
            conn.close()
            

def item_exists(item):
    conn = get_connection()
    try:
        cursor = conn.cursor()
        cursor.execute("SELECT COUNT(*) FROM CZE_ControllerBattCharger WHERE Item_batterycharger = ?", (item,))
        result = cursor.fetchone()
        return result
    finally:
        if conn:
            conn.close()

def insert_Catalogo_de_cargadores_de_baterias(item, description, price, technicalSheet):
    """Inserta un nuevo breaker en la base de datos."""
    query = """
    INSERT INTO CZE_ControllerBattCharger (Item_batterycharger, description, price,TechnicalSheet)
    VALUES (?, ?, ?, ?)
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (item, description, price, technicalSheet))
        
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error insertando Catálogo de cargadores de baterías : {e}")
    finally:
        if conn:
            conn.close()
            
def update_Catalogo_de_cargadores_de_baterias(item, description, price):
    """Actualiza un breaker en la base de datos."""
    query = """
    UPDATE CZE_ControllerBattCharger
    SET description = ?, price = ?
    WHERE Item_batterycharger = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (description, price, item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando breaker: {e}")
    finally:
        if conn:
            conn.close()
            
def delete_Catalogo_de_cargadores_de_baterias(item):
    """Elimina un breaker de la base de datos."""
    query = """
    DELETE FROM CZE_ControllerBattCharger
    WHERE Item_batterycharger = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (item,))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error eliminando el Catálogo de cargadores de baterías : {e}")
    finally:
        if conn:
            conn.close()

def searchitems():
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        cursor = conn.cursor()
        cursor.execute("SELECT Item_batterycharger, TechnicalSheet from CZE_ControllerBattCharger")
        results = cursor.fetchall()
        if not results:  # Verifica si la tabla está vacía
            return []  # Devuelve una lista vacía si no hay datos
        return [{"Item_batterycharger": row[0], "TechnicalSheet": row[1]} for row in results]
        
    except Exception as e:
        print(f"[Error inesperado] Error consultando Catálogo de cargadores de baterías : {e}")
        return []
    finally:
        if conn:
            conn.close()

def update_Catalogo_de_cargadores_de_baterias_TechnicalSheet(item, TechnicalSheet):
    """Actualiza la ficha técnica de un Catálogo de cargadores de baterías  en la base de datos."""
    query = """
    UPDATE CZE_ControllerBattCharger
    SET TechnicalSheet = ?
    WHERE Item_batterycharger = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (TechnicalSheet, item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando ficha técnica: {e}")
    finally:
        if conn:
            conn.close()