# Optimized Python Code
# Archivo: DMCatalogo_de_controlesSQL.py
# Ruta: src\Consultas_SQL\Ventas\VentasEUA\DataMaster\DMCatalogo_de_controlesSQL.py
# Lenguaje: Python


from Consultas_SQL.conexion import get_connection
def get_Catalogo_de_controles():
    """Obtiene catalogo de controles desde la base de datos."""
    query = """
     SELECT
        CZE_ControllerCatalog.Item_controller, 
        CZE_ControllerCatalog.description, 
        CZE_ControllerCatalog.price, 
        CZE_ControllerCatalog.BrandID,
        CZE_ControllerCatalog.TechnicalSheet
    FROM
        CZE_ControllerCatalog
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query)
        results = cursor.fetchall()
        
        # Aseguramos que las claves del diccionario coincidan con las usadas en el JavaScript
        return [{"Item_controller": row[0], "description": row[1], "price": row[2], "BrandID": row[3], "TechnicalSheet": row[4]} for row in results]
    except Exception as e:
        print(f"[Error inesperado] Error obteniendo Catálogo de controles: {e}")
        return []
    finally:
        if conn:
            conn.close()
            

def item_exists(item):
    conn = get_connection()
    try:
        cursor = conn.cursor()
        cursor.execute("SELECT COUNT(*) FROM CZE_ControllerCatalog WHERE Item_controller = ?", (item,))
        result = cursor.fetchone()
        return result
    finally:
        if conn:
            conn.close()

def insert_Catalogo_de_controles(item, description, price, type, technicalSheet):
    """Inserta un nuevo breaker en la base de datos."""
    query = """
    INSERT INTO CZE_ControllerCatalog (Item_controller, description, price, BrandID, TechnicalSheet)
    VALUES (?, ?, ?, ?, ?)
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (item, description, price, type, technicalSheet))
        
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error insertando breaker: {e}")
    finally:
        if conn:
            conn.close()
            
def update_Catalogo_de_controles(item, description, price, type):
    """Actualiza un breaker en la base de datos."""
    query = """
    UPDATE CZE_ControllerCatalog
    SET description = ?, price = ?, BrandID = ?
    WHERE Item_controller = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (description, price, type, item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando Catálogo de controles : {e}")
    finally:
        if conn:
            conn.close()
            
def delete_Catalogo_de_controles(item):
    """Elimina un breaker de la base de datos."""
    query = """
    DELETE FROM CZE_ControllerCatalog
    WHERE Item_controller = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (item,))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error eliminando el Control: {e}")
    finally:
        if conn:
            conn.close()

def searchitems():
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        cursor = conn.cursor()
        cursor.execute("SELECT Item_controller, TechnicalSheet from CZE_ControllerCatalog")
        results = cursor.fetchall()
        if not results:  # Verifica si la tabla está vacía
            return []  # Devuelve una lista vacía si no hay datos
        return [{"Item_controller": row[0], "TechnicalSheet": row[1]} for row in results]
        
    except Exception as e:
        print(f"[Error inesperado] Error consultando Catálogo de controles : {e}")
        return []
    finally:
        if conn:
            conn.close()

def update_Catalogo_de_controles_TechnicalSheet(item, TechnicalSheet):
    """Actualiza la ficha técnica de un breaker en la base de datos."""
    query = """
    UPDATE CZE_ControllerCatalog
    SET TechnicalSheet = ?
    WHERE Item_controller = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (TechnicalSheet, item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando ficha técnica: {e}")
    finally:
        if conn:
            conn.close()