# Archivo: DMControllerOptionsSQL.py
# Ruta: src\Consultas_SQL\Ventas\VentasEUA\DataMaster\DMControllerOptionsSQL.py
# Lenguaje: Python

from Consultas_SQL.conexion import get_connection
def get_ControllerOptions():
    """Obtiene los Breakers desde la base de datos."""
    query = """
    SELECT
        CZE_ControllerOptions.Item_controller_options, 
        CZE_ControllerOptions.description, 
        CZE_ControllerOptions.price, 
        CZE_ControllerOptions.TechnicalSheet
    FROM
        CZE_ControllerOptions
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query)
        results = cursor.fetchall()
        
        return [{"Item_controller_options": row[0], "description": row[1], "price": row[2], "TechnicalSheet": row[3]} for row in results]
    except Exception as e:
        print(f"[Error inesperado] Error obteniendo breakers: {e}")
        return []
    finally:
        if conn:
            conn.close()
            

def item_exists(item):
    conn = get_connection()
    try:  # Es una buena práctica usar un bloque try...finally para asegurar que la conexión se cierre.
        cursor = conn.cursor()
        cursor.execute("SELECT COUNT(*) FROM CZE_ControllerOptions WHERE Item_controller_options = ?", (item,))
        result = cursor.fetchone()
        return result
    finally: # Esta parte es importante para cerrar la conexión sin importar si hay un error o no
        if conn:
            conn.close()

         
def update_ControllerOptions(item, price):
    """Actualiza un breaker en la base de datos."""
    query = """
    UPDATE CZE_ControllerOptions
    SET  price = ?
    WHERE Item_controller_options = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, ( price,item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando Catálogo de opciones del control : {e}")
    finally:
        if conn:
            conn.close()
            

def searchitems():
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        cursor = conn.cursor()
        cursor.execute("SELECT Item_controller_options,TechnicalSheet from CZE_ControllerOptions ")
        results = cursor.fetchall()
        if not results:  # Verifica si la tabla está vacía
            return []  # Devuelve una lista vacía si no hay datos
        return [{"Item_controller_options": row[0], "TechnicalSheet": row[1]} for row in results]
        
    except Exception as e:
        print(f"[Error inesperado] Error eliminando Catálogo de opciones del control: {e}")
        return []
    finally:
        if conn:
            conn.close()

def update_ControllerOptions_TechnicalSheet(item,TechnicalSheet):
    """Actualiza un Catálogo de opciones del control  en la base de datos."""
    query = """
    UPDATE CZE_ControllerOptions
    SET TechnicalSheet = ?
    WHERE Item_controller_options = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (TechnicalSheet,item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando Catálogo de opciones del control : {e}")
    finally:
        if conn:
            conn.close()