# Optimized Python Code
# Archivo: DMEnclosureLightSQL.py
# Ruta: src\Consultas_SQL\Ventas\VentasEUA\DataMaster\DMEnclosureLightSQL.py
# Lenguaje: Python


from Consultas_SQL.conexion import get_connection
def get_Catalogo_de_iluminacion_de_casetas():
    """Obtiene catalogo de controles desde la base de datos."""
    query = """
     SELECT
        CZE_EnclosureLight.Item_Enclosure_ligth, 
        CZE_EnclosureLight.description, 
        CZE_EnclosureLight.price, 
        CZE_EnclosureLight.type,
        CZE_EnclosureLight.TechnicalSheet
    FROM
        CZE_EnclosureLight
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query)
        results = cursor.fetchall()
        
        # Aseguramos que las claves del diccionario coincidan con las usadas en el JavaScript
        return [{"Item_Enclosure_ligth": row[0], "description": row[1], "price": row[2], "type": row[3], "TechnicalSheet": row[4]} for row in results]
    except Exception as e:
        print(f"[Error inesperado] Error obteniendo Catálogo de iluminación de casetas: {e}")
        return []
    finally:
        if conn:
            conn.close()
            

def item_exists(item):
    conn = get_connection()
    try:
        cursor = conn.cursor()
        cursor.execute("SELECT COUNT(*) FROM CZE_EnclosureLight WHERE Item_Enclosure_ligth = ?", (item,))
        result = cursor.fetchone()
        return result
    finally:
        if conn:
            conn.close()

def insert_Catalogo_de_iluminacion_de_casetas(item, description, price, type, technicalSheet):
    """Inserta un nuevo breaker en la base de datos."""
    query = """
    INSERT INTO CZE_EnclosureLight (Item_Enclosure_ligth, description, price, type, TechnicalSheet)
    VALUES (?, ?, ?, ?, ?)
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (item, description, price, type, technicalSheet))
        
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error insertando Catálogo de iluminación de casetas : {e}")
    finally:
        if conn:
            conn.close()
            
def update_Catalogo_de_iluminacion_de_casetas(item, description, price, type):
    """Actualiza un Catálogo de iluminación de casetas en la base de datos."""
    query = """
    UPDATE CZE_EnclosureLight
    SET description = ?, price = ?, type = ?
    WHERE Item_Enclosure_ligth = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (description, price, type, item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando Catálogo de iluminación de casetas  : {e}")
    finally:
        if conn:
            conn.close()
            
def delete_Catalogo_de_iluminacion_de_casetas(item):
    """Elimina un Catálogo de iluminación de casetas  de la base de datos."""
    query = """
    DELETE FROM CZE_EnclosureLight
    WHERE Item_Enclosure_ligth = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (item,))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error eliminando el Catálogo de iluminación de casetas : {e}")
    finally:
        if conn:
            conn.close()

def searchitems():
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        cursor = conn.cursor()
        cursor.execute("SELECT Item_Enclosure_ligth, TechnicalSheet from CZE_EnclosureLight")
        results = cursor.fetchall()
        if not results:  # Verifica si la tabla está vacía
            return []  # Devuelve una lista vacía si no hay datos
        return [{"Item_Enclosure_ligth": row[0], "TechnicalSheet": row[1]} for row in results]
        
    except Exception as e:
        print(f"[Error inesperado] Error consultando Catálogo de iluminación de casetas : {e}")
        return []
    finally:
        if conn:
            conn.close()

def update_Catalogo_de_iluminacion_de_casetas_TechnicalSheet(item, TechnicalSheet):
    """Actualiza la ficha técnica de un Catálogo de iluminación de casetas en la base de datos."""
    query = """
    UPDATE CZE_EnclosureLight
    SET TechnicalSheet = ?
    WHERE Item_Enclosure_ligth = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (TechnicalSheet, item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando ficha técnica: {e}")
    finally:
        if conn:
            conn.close()