# Archivo: DMEnclosureOptionSQL.py
# Ruta: src\Consultas_SQL\Ventas\VentasEUA\DataMaster\DMEnclosureOptionSQL.py
# Lenguaje: Python

from Consultas_SQL.conexion import get_connection
def get_EnclosureOption():
    """Obtiene los Catálogo de componentes adicionales de casetas  desde la base de datos."""
    query = """
    SELECT
        CZE_EnclosureOption.Item_Enclosure_options, 
        CZE_EnclosureOption.description, 
        CZE_EnclosureOption.price, 
        CZE_EnclosureOption.TechnicalSheet
    FROM
        CZE_EnclosureOption
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query)
        results = cursor.fetchall()
        
        return [{"Item_Enclosure_options": row[0], "description": row[1], "price": row[2], "TechnicalSheet": row[3]} for row in results]
    except Exception as e:
        print(f"[Error inesperado] Error obteniendo Catálogo de componentes adicionales de casetas : {e}")
        return []
    finally:
        if conn:
            conn.close()
            

def item_exists(item):
    conn = get_connection()
    try:  # Es una buena práctica usar un bloque try...finally para asegurar que la conexión se cierre.
        cursor = conn.cursor()
        cursor.execute("SELECT COUNT(*) FROM CZE_EnclosureOption WHERE Item_Enclosure_options = ?", (item,))
        result = cursor.fetchone()
        return result
    finally: # Esta parte es importante para cerrar la conexión sin importar si hay un error o no
        if conn:
            conn.close()

         
def update_EnclosureOption(item, price):
    """Actualiza un Catálogo de componentes adicionales de casetas   en la base de datos."""
    query = """
    UPDATE CZE_EnclosureOption
    SET  price = ?
    WHERE Item_Enclosure_options = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, ( price,item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando Catálogo de componentes adicionales de casetas  : {e}")
    finally:
        if conn:
            conn.close()
            

def searchitems():
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        cursor = conn.cursor()
        cursor.execute("SELECT Item_Enclosure_options,TechnicalSheet from CZE_EnclosureOption ")
        results = cursor.fetchall()
        if not results:  # Verifica si la tabla está vacía
            return []  # Devuelve una lista vacía si no hay datos
        return [{"Item_Enclosure_options": row[0], "TechnicalSheet": row[1]} for row in results]
        
    except Exception as e:
        print(f"[Error inesperado] Error eliminando Catálogo de componentes adicionales de casetas : {e}")
        return []
    finally:
        if conn:
            conn.close()

def update_EnclosureOption_TechnicalSheet(item,TechnicalSheet):
    """Actualiza un Catálogo de componentes adicionales de casetas en la base de datos."""
    query = """
    UPDATE CZE_EnclosureOption
    SET TechnicalSheet = ?
    WHERE Item_Enclosure_options = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (TechnicalSheet,item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando Catálogo de componentes adicionales de casetas: {e}")
    finally:
        if conn:
            conn.close()