# Optimized Python Code
# Archivo: DMEnclosureSpaceHeaterSQL.py
# Ruta: src\Consultas_SQL\Ventas\VentasEUA\DataMaster\DMEnclosureSpaceHeaterSQL.py
# Lenguaje: Python


from Consultas_SQL.conexion import get_connection
def get_Catalogo_de_calentadores_de_espacio_para_casetas():
    """Obtiene catalogo de controles desde la base de datos."""
    query = """
     SELECT
        CZE_EnclosureSpaceHeater.Item_Enclosure_SHeater, 
        CZE_EnclosureSpaceHeater.description, 
        CZE_EnclosureSpaceHeater.price, 
        CZE_EnclosureSpaceHeater.TechnicalSheet
    FROM
        CZE_EnclosureSpaceHeater
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query)
        results = cursor.fetchall()
        
        # Aseguramos que las claves del diccionario coincidan con las usadas en el JavaScript
        return [{"Item_Enclosure_SHeater": row[0], "description": row[1], "price": row[2], "TechnicalSheet": row[3]} for row in results]
    except Exception as e:
        print(f"[Error inesperado] Error obteniendo breakers: {e}")
        return []
    finally:
        if conn:
            conn.close()
            

def item_exists(item):
    conn = get_connection()
    try:
        cursor = conn.cursor()
        cursor.execute("SELECT COUNT(*) FROM CZE_EnclosureSpaceHeater WHERE Item_Enclosure_SHeater = ?", (item,))
        result = cursor.fetchone()
        return result
    finally:
        if conn:
            conn.close()

def insert_Catalogo_de_calentadores_de_espacio_para_casetas(item, description, price, technicalSheet):
    """Inserta un nuevo breaker en la base de datos."""
    query = """
    INSERT INTO CZE_EnclosureSpaceHeater (Item_Enclosure_SHeater, description, price,TechnicalSheet)
    VALUES (?, ?, ?, ?)
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (item, description, price, technicalSheet))
        
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error insertando Catálogo de calentadores de espacio para casetas: {e}")
    finally:
        if conn:
            conn.close()
            
def update_Catalogo_de_calentadores_de_espacio_para_casetas(item, description, price):
    """Actualiza un Catálogo de calentadores de espacio para casetas en la base de datos."""
    query = """
    UPDATE CZE_EnclosureSpaceHeater
    SET description = ?, price = ?
    WHERE Item_Enclosure_SHeater = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (description, price, item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando Catálogo de calentadores de espacio para casetas: {e}")
    finally:
        if conn:
            conn.close()
            
def delete_Catalogo_de_calentadores_de_espacio_para_casetas(item):
    """Elimina un Catálogo de calentadores de espacio para casetas de la base de datos."""
    query = """
    DELETE FROM CZE_EnclosureSpaceHeater
    WHERE Item_Enclosure_SHeater = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (item,))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error eliminando el Catálogo de calentadores de espacio para casetas: {e}")
    finally:
        if conn:
            conn.close()

def searchitems():
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        cursor = conn.cursor()
        cursor.execute("SELECT Item_Enclosure_SHeater, TechnicalSheet from CZE_EnclosureSpaceHeater")
        results = cursor.fetchall()
        if not results:  # Verifica si la tabla está vacía
            return []  # Devuelve una lista vacía si no hay datos
        return [{"Item_Enclosure_SHeater": row[0], "TechnicalSheet": row[1]} for row in results]
        
    except Exception as e:
        print(f"[Error inesperado] Error consultando Catálogo de calentadores de espacio para casetas: {e}")
        return []
    finally:
        if conn:
            conn.close()

def update_Catalogo_de_calentadores_de_espacio_para_casetas_TechnicalSheet(item, TechnicalSheet):
    """Actualiza la ficha técnica de un Catálogo de calentadores de espacio para casetas en la base de datos."""
    query = """
    UPDATE CZE_EnclosureSpaceHeater
    SET TechnicalSheet = ?
    WHERE Item_Enclosure_SHeater = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (TechnicalSheet, item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando ficha técnica: {e}")
    finally:
        if conn:
            conn.close()