# Optimized Python Code
# Archivo: DMPrjWarWarrantySQL.py
# Ruta: src\Consultas_SQL\Ventas\VentasEUA\DataMaster\DMPrjWarWarrantySQL.py
# Lenguaje: Python


from Consultas_SQL.conexion import get_connection
def get_Catalogo_de_garantias():
    """Obtiene catalogo de controles desde la base de datos."""
    query = """
     SELECT
        CZE_PrjWarWarranty.Item_PrjWar_Warranty, 
        CZE_PrjWarWarranty.description, 
        CZE_PrjWarWarranty.Percentage
    FROM
        CZE_PrjWarWarranty
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query)
        results = cursor.fetchall()
        
        # Aseguramos que las claves del diccionario coincidan con las usadas en el JavaScript
        return [{"Item_PrjWar_Warranty": row[0], "description": row[1], "Percentage": row[2]} for row in results]
    except Exception as e:
        print(f"[Error inesperado] Error obteniendo breakers: {e}")
        return []
    finally:
        if conn:
            conn.close()
            

def item_exists(item):
    conn = get_connection()
    try:
        cursor = conn.cursor()
        cursor.execute("SELECT COUNT(*) FROM CZE_PrjWarWarranty WHERE Item_PrjWar_Warranty = ?", (item,))
        result = cursor.fetchone()
        return result
    finally:
        if conn:
            conn.close()

def insert_Catalogo_de_garantias(item, description, Percentage):
    """Inserta un nuevo breaker en la base de datos."""
    query = """
    INSERT INTO CZE_PrjWarWarranty (Item_PrjWar_Warranty, description, Percentage)
    VALUES (?, ?, ?)
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (item, description, Percentage))
        
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error insertando breaker: {e}")
    finally:
        if conn:
            conn.close()
            
def update_Catalogo_de_garantias(item, description, Percentage):
    """Actualiza un breaker en la base de datos."""
    query = """
    UPDATE CZE_PrjWarWarranty
    SET description = ?, Percentage = ?
    WHERE Item_PrjWar_Warranty = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (description, Percentage, item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando breaker: {e}")
    finally:
        if conn:
            conn.close()
            
def delete_Catalogo_de_garantias(item):
    """Elimina un Catálogo de garantías de la base de datos."""
    query = """
    DELETE FROM CZE_PrjWarWarranty
    WHERE Item_PrjWar_Warranty = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (item,))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error eliminando el Control: {e}")
    finally:
        if conn:
            conn.close()

def searchitems():
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        cursor = conn.cursor()
        cursor.execute("SELECT Item_PrjWar_Warranty from CZE_PrjWarWarranty")
        results = cursor.fetchall()
        if not results:  # Verifica si la tabla está vacía
            return []  # Devuelve una lista vacía si no hay datos
        return [{"Item_PrjWar_Warranty": row[0]} for row in results]
        
    except Exception as e:
        print(f"[Error inesperado] Error consultando Catálogo de garantías : {e}")
        return []
    finally:
        if conn:
            conn.close()
