# Archivo: DMTankOptionsSQL.py
# Ruta: src\Consultas_SQL\Ventas\VentasEUA\DataMaster\DMTankOptionsSQL.py
# Lenguaje: Python

from Consultas_SQL.conexion import get_connection
def get_TankOptions():
    """Obtiene los Breakers desde la base de datos."""
    query = """
    SELECT
        CZE_TankOptions.Item_Tank_option, 
        CZE_TankOptions.description, 
        CZE_TankOptions.price, 
        CZE_TankOptions.TechnicalSheet
    FROM
        CZE_TankOptions
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query)
        results = cursor.fetchall()
        
        return [{"Item_Tank_option": row[0], "description": row[1], "price": row[2], "TechnicalSheet": row[3]} for row in results]
    except Exception as e:
        print(f"[Error inesperado] Error obteniendo Catálogo de componentes adicionales de tanques : {e}")
        return []
    finally:
        if conn:
            conn.close()
            

def item_exists(item):
    conn = get_connection()
    try:  # Es una buena práctica usar un bloque try...finally para asegurar que la conexión se cierre.
        cursor = conn.cursor()
        cursor.execute("SELECT COUNT(*) FROM CZE_TankOptions WHERE Item_Tank_option = ?", (item,))
        result = cursor.fetchone()
        return result
    finally: # Esta parte es importante para cerrar la conexión sin importar si hay un error o no
        if conn:
            conn.close()

         
def update_TankOptions(item, price):
    """Actualiza un Catálogo de componentes adicionales de tanques  en la base de datos."""
    query = """
    UPDATE CZE_TankOptions
    SET  price = ?
    WHERE Item_Tank_option = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, ( price,item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando Catálogo de componentes adicionales de tanques : {e}")
    finally:
        if conn:
            conn.close()
            

def searchitems():
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        cursor = conn.cursor()
        cursor.execute("SELECT Item_Tank_option,TechnicalSheet from CZE_TankOptions ")
        results = cursor.fetchall()
        if not results:  # Verifica si la tabla está vacía
            return []  # Devuelve una lista vacía si no hay datos
        return [{"Item_Tank_option": row[0], "TechnicalSheet": row[1]} for row in results]
        
    except Exception as e:
        print(f"[Error inesperado] Error eliminando Catálogo de componentes adicionales de tanques  : {e}")
        return []
    finally:
        if conn:
            conn.close()

def update_TankOptions_TechnicalSheet(item,TechnicalSheet):
    """Actualiza un Catálogo de componentes adicionales de tanques en la base de datos."""
    query = """
    UPDATE CZE_TankOptions
    SET TechnicalSheet = ?
    WHERE Item_Tank_option = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (TechnicalSheet,item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando Catálogo de componentes adicionales de tanques: {e}")
    finally:
        if conn:
            conn.close()