# Optimized Python Code
# Archivo: DMTankSpillContSQL.py
# Ruta: src\Consultas_SQL\Ventas\VentasEUA\DataMaster\DMTankSpillContSQL.py
# Lenguaje: Python


from Consultas_SQL.conexion import get_connection
def get_Catalogo_de_contencion_de_derrames_de_tanques():
    """Obtiene catalogo de controles desde la base de datos."""
    query = """
     SELECT
        CZE_TankSpillCont.Item_Tank_SpillCont, 
        CZE_TankSpillCont.description, 
        CZE_TankSpillCont.price, 
        CZE_TankSpillCont.TechnicalSheet
    FROM
        CZE_TankSpillCont
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query)
        results = cursor.fetchall()
        
        # Aseguramos que las claves del diccionario coincidan con las usadas en el JavaScript
        return [{"Item_Tank_SpillCont": row[0], "description": row[1], "price": row[2], "TechnicalSheet": row[3]} for row in results]
    except Exception as e:
        print(f"[Error inesperado] Error obteniendo breakers: {e}")
        return []
    finally:
        if conn:
            conn.close()
            

def item_exists(item):
    conn = get_connection()
    try:
        cursor = conn.cursor()
        cursor.execute("SELECT COUNT(*) FROM CZE_TankSpillCont WHERE Item_Tank_SpillCont = ?", (item,))
        result = cursor.fetchone()
        return result
    finally:
        if conn:
            conn.close()

def insert_Catalogo_de_contencion_de_derrames_de_tanques(item, description, price, technicalSheet):
    """Inserta un nuevo Catálogo de contención de derrames de tanques en la base de datos."""
    query = """
    INSERT INTO CZE_TankSpillCont (Item_Tank_SpillCont, description, price,TechnicalSheet)
    VALUES (?, ?, ?, ?)
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (item, description, price, technicalSheet))
        
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error insertando Catálogo de contención de derrames de tanques : {e}")
    finally:
        if conn:
            conn.close()
            
def update_Catalogo_de_contencion_de_derrames_de_tanques(item, description, price):
    """Actualiza un breaker en la base de datos."""
    query = """
    UPDATE CZE_TankSpillCont
    SET description = ?, price = ?
    WHERE Item_Tank_SpillCont = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (description, price, item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando Catálogo de contención de derrames de tanques  : {e}")
    finally:
        if conn:
            conn.close()
            
def delete_Catalogo_de_contencion_de_derrames_de_tanques(item):
    """Elimina un Catálogo de contención de derrames de tanques de la base de datos."""
    query = """
    DELETE FROM CZE_TankSpillCont
    WHERE Item_Tank_SpillCont = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (item,))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error eliminando el Catálogo de contención de derrames de tanques: {e}")
    finally:
        if conn:
            conn.close()

def searchitems():
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        cursor = conn.cursor()
        cursor.execute("SELECT Item_Tank_SpillCont, TechnicalSheet from CZE_TankSpillCont")
        results = cursor.fetchall()
        if not results:  # Verifica si la tabla está vacía
            return []  # Devuelve una lista vacía si no hay datos
        return [{"Item_Tank_SpillCont": row[0], "TechnicalSheet": row[1]} for row in results]
        
    except Exception as e:
        print(f"[Error inesperado] Error consultando Catálogo de contención de derrames de tanques: {e}")
        return []
    finally:
        if conn:
            conn.close()

def update_Catalogo_de_contencion_de_derrames_de_tanques_TechnicalSheet(item, TechnicalSheet):
    """Actualiza la ficha técnica de un Catálogo de contención de derrames de tanques en la base de datos."""
    query = """
    UPDATE CZE_TankSpillCont
    SET TechnicalSheet = ?
    WHERE Item_Tank_SpillCont = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (TechnicalSheet, item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando ficha técnica: {e}")
    finally:
        if conn:
            conn.close()