# Optimized Python Code
# Archivo: DMbreakersSQL.py
# Ruta: src\Consultas_SQL\Ventas\VentasEUA\DataMaster\DMbreakersSQL.py
# Lenguaje: Python
from Consultas_SQL.conexion import get_connection
def get_breakers():
    """Obtiene los Breakers desde la base de datos."""
    query = """
    SELECT
        CZE_BreakersCatalog.Item_breaker, 
        CZE_BreakersCatalog.description, 
        CZE_BreakersCatalog.price, 
        CZE_BreakersCatalog.type,
        CZE_BreakersCatalog.TechnicalSheet
    FROM
        CZE_BreakersCatalog
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query)
        results = cursor.fetchall()
        
        return [{"Item_breaker": row[0], "description": row[1], "price": row[2], "type": row[3], "TechnicalSheet": row[4]} for row in results]
    except Exception as e:
        print(f"[Error inesperado] Error obteniendo breakers: {e}")
        return []
    finally:
        if conn:
            conn.close()
            

def item_exists(item):
    conn = get_connection()
    try:  # Es una buena práctica usar un bloque try...finally para asegurar que la conexión se cierre.
        cursor = conn.cursor()
        cursor.execute("SELECT COUNT(*) FROM CZE_BreakersCatalog WHERE Item_breaker = ?", (item,))
        result = cursor.fetchone()
        return result
    finally: # Esta parte es importante para cerrar la conexión sin importar si hay un error o no
        if conn:
            conn.close()

def insert_breaker(item, description, price, type,technicalSheet):
    """Inserta un nuevo breaker en la base de datos."""
    query = """
    INSERT INTO CZE_BreakersCatalog (Item_breaker, description, price, type,TechnicalSheet)
    VALUES (?, ?, ?, ?,?)
    
    """
    #VALUES (%s, %s, %s, %s, %s)
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (item, description, price, type,technicalSheet))
        
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error insertando breaker: {e}")
    finally:
        if conn:
            conn.close()
            
def update_breaker(item, description, price, type):
    """Actualiza un breaker en la base de datos."""
    query = """
    UPDATE CZE_BreakersCatalog
    SET description = ?, price = ?, type = ?
    WHERE Item_breaker = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (description, price, type, item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando breaker: {e}")
    finally:
        if conn:
            conn.close()
            
def delete_breaker(item):
    """Elimina un breaker de la base de datos."""
    query = """
    DELETE FROM CZE_BreakersCatalog
    WHERE Item_breaker = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (item,))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error eliminando breaker: {e}")
    finally:
        if conn:
            conn.close()

def searchitems():
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        cursor = conn.cursor()
        cursor.execute("SELECT Item_breaker, TechnicalSheet FROM CZE_BreakersCatalog")
        results = cursor.fetchall()
        if not results:  # Verifica si la tabla está vacía
            return []  # Devuelve una lista vacía si no hay datos
        return [{"Item_breaker": row[0], "TechnicalSheet": row[1]} for row in results]
        
    except Exception as e:
        print(f"[Error inesperado] Error consultando breakers: {e}")
        return []
    finally:
        if conn:
            conn.close()
            
def update_breaker_TechnicalSheet(item,TechnicalSheet):
    """Actualiza un breaker en la base de datos."""
    query = """
    UPDATE CZE_BreakersCatalog
    SET TechnicalSheet = ?
    WHERE Item_breaker = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (TechnicalSheet,item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando breaker: {e}")
    finally:
        if conn:
            conn.close()