# Archivo: EnclosureSQL.py
# Ruta: src\Consultas_SQL\Ventas\VentasEUA\DataMaster\EnclosureSQL.py
# Lenguaje: Python

from Consultas_SQL.conexion import get_connection

def get_Enclosure():
    """Obtiene los Enclosures desde la base de datos."""
    query = """
    SELECT
        ConfigID,
        CertificationID,
        Fueltype,
        Item_Enclosure_type,
        Item_Enclosure_Mat,
        KWOutPut,
        Cost,
        Evaluator,
        TechnicalSheet
    FROM
        CZE_EnclosureConfig
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query)
        results = cursor.fetchall()

        return [{
            "ConfigID": row[0],
            "CertificationID": row[1], 
            "Fueltype": row[2],
            "Item_Enclosure_type": row[3],
            "Item_Enclosure_Mat": row[4],
            "KWOutPut": float(row[5]) if row[5] else 0.0,
            "Cost": row[6],
            "Evaluator": row[7],
            "TechnicalSheet": row[8],
        } for row in results]
    except Exception as e:
        print(f"[Error inesperado] Error obteniendo Catálogo de componentes adicionales de casetas : {e}")
        return []
    finally:
        if conn:
            conn.close()


def item_exists(item):
    conn = get_connection()
    try:  # Es una buena práctica usar un bloque try...finally para asegurar que la conexión se cierre.
        cursor = conn.cursor()
        cursor.execute("SELECT COUNT(*) FROM CZE_EnclosureConfig WHERE ConfigID = ?", (item,))
        result = cursor.fetchone()
        return result
    finally: # Esta parte es importante para cerrar la conexión sin importar si hay un error o no
        if conn:
            conn.close()

def update_Enclosure(item, price):
    """Actualiza un Catálogo de componentes adicionales de casetas en la base de datos."""
    query = """
    UPDATE CZE_EnclosureConfig
    SET Cost = ?
    WHERE ConfigID = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (price, item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando Catálogo de componentes adicionales de casetas : {e}")
    finally:
        if conn:
            conn.close()

def searchitems():
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        cursor = conn.cursor()
        cursor.execute("SELECT ConfigID, TechnicalSheet FROM CZE_EnclosureConfig")
        results = cursor.fetchall()
        if not results:  # Verifica si la tabla está vacía
            return []  # Devuelve una lista vacía si no hay datos

        return [{"ConfigID": row[0], "TechnicalSheet": row[1]} for row in results]
    
    except Exception as e:
        print(f"[Error inesperado] Error obteniendo items de Catálogo de componentes adicionales de casetas : {e}")
        return []
    finally:
        if conn:
            conn.close()

def update_Enclosure_TechnicalSheet(item, TechnicalSheet):
    """Actualiza la ficha técnica de un componente de casetas en la base de datos."""
    query = """
    UPDATE CZE_EnclosureConfig 
    SET TechnicalSheet = ? 
    WHERE ConfigID = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (TechnicalSheet, item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando ficha técnica de Catálogo de componentes adicionales de casetas: {e}")
    finally:
        if conn:
            conn.close()