# Archivo: GensetSQL.py
# Ruta: src/Consultas_SQL/Ventas/VentasEUA/DataMaster/GensetSQL.py

from Consultas_SQL.conexion import get_connection

def get_GensetCost():
    """Obtiene todos los registros de la tabla CZE_GensetCost"""
    query = """
    SELECT 
        CostID,
        ConfigID,
        ControllerBrandID,
        Cost,
        Evaluator,
        TechnicalSheet
    FROM CZE_GensetCost
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query)
        results = cursor.fetchall()

        return [{
            "CostID": row[0],
            "ConfigID": row[1], 
            "ControllerBrandID": row[2],
            "Cost": row[3],
            "Evaluator": row[4],
            "TechnicalSheet": row[5],            
        } for row in results]
    except Exception as e:
        print(f"[Error inesperado] Error obteniendo Catálogo de componentes adicionales de plantas electricas : {e}")
        return []
    finally:
        if conn:
            conn.close()


def item_exists(item):
    conn = get_connection()
    try:  # Es una buena práctica usar un bloque try...finally para asegurar que la conexión se cierre.
        cursor = conn.cursor()
        cursor.execute("SELECT COUNT(*) FROM CZE_GensetCost WHERE CostID = ?", (item,))
        result = cursor.fetchone()
        return result
    finally: # Esta parte es importante para cerrar la conexión sin importar si hay un error o no
        if conn:
            conn.close()

def update_GensetCost(item, configID, controllerBrandID, Cost, Evaluator):
    """Actualiza un Catálogo de componentes adicionales de plantas eléctricas en la base de datos."""
    query = """
    UPDATE CZE_GensetCost
    SET ConfigID = ?, ControllerBrandID = ?, Cost = ?, Evaluator = ?
    WHERE CostID = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        # --- Lógica añadida de cambio Cost > 0 → Evaluator = 1 ; Cost = 0 → Evaluator = 0 ---
        Evaluator = 1 if float(Cost) > 0 else 0  
        # ----------------------------------------------

        # --- Lógica añadida de clave: Cost = 0 → NULL en DB ---
        Cost = None if float(Cost) == 0 else Cost  # Si Cost es 0, se guarda como NULL
        # ----------------------------------------------
        
        cursor = conn.cursor()
        cursor.execute(query, (configID, controllerBrandID, Cost, Evaluator, item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando Catálogo de componentes adicionales de plantas eléctricas: {e}")
    finally:
        if conn:
            conn.close()


def searchitems():
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        cursor = conn.cursor()
        cursor.execute("SELECT CostID, TechnicalSheet FROM CZE_GensetCost")
        results = cursor.fetchall()
        if not results:  # Verifica si la tabla está vacía
            return []  # Devuelve una lista vacía si no hay datos

        return [{"CostID": row[0], "TechnicalSheet": row[1]} for row in results]
    
    except Exception as e:
        print(f"[Error inesperado] Error obteniendo items de Catálogo de componentes adicionales de plantas eléctricas : {e}")
        return []
    finally:
        if conn:
            conn.close()

def update_Genset_TechnicalSheet(item, TechnicalSheet):
    """Actualiza la ficha técnica de un componente de casetas en la base de datos."""
    query = """
    UPDATE CZE_GensetCost 
    SET TechnicalSheet = ? 
    WHERE CostID = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (TechnicalSheet, item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando ficha técnica de Catálogo de componentes adicionales de plantas eléctricas: {e}")
    finally:
        if conn:
            conn.close()