# Archivo: TankSQL.py
# Ruta: src\Consultas_SQL\Ventas\VentasEUA\DataMaster\TankSQL.py
# Lenguaje: Python

from Consultas_SQL.conexion import get_connection
def get_Tank():
    """Obtiene todos los tanques desde la base de datos."""
    query = """
    SELECT
        ConfigID,
        KWOutput,
        Item_Tank_Autonomy,
        Item_Tank_Type,
        CapacityGAL,
        Cost,
        Evaluator,
        TechnicalSheet
    FROM
        CZE_TankConfig
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query)
        results = cursor.fetchall()
        
        return [{
            "ConfigID": row[0],
            "KWOutput": float(row[1]) if row[1] else 0.0,
            "Item_Tank_Autonomy": row[2],
            "Item_Tank_Type": row[3],
            "CapacityGAL": float(row[4]) if row[4] else 0.0,
            "Cost": row[5],
            "Evaluator": row[6],
            "TechnicalSheet": row[7],
        } for row in results]
    except Exception as e:
        print(f"[Error inesperado] Error obteniendo Catálogo de componentes adicionales de tanques : {e}")
        return []
    finally:
        if conn:
            conn.close()

def item_exists(item):
    conn = get_connection()
    try:  # Es una buena práctica usar un bloque try...finally para asegurar que la conexión se cierre.
        cursor = conn.cursor()
        cursor.execute("SELECT COUNT(*) FROM CZE_TankConfig WHERE ConfigID = ?", (item,))
        result = cursor.fetchone()
        return result
    finally: # Esta parte es importante para cerrar la conexión sin importar si hay un error o no
        if conn:
            conn.close()

def update_Tank(price, item):
    """Actualiza los datos de un tanque."""
    query = """
    UPDATE CZE_TankConfig
    SET 
        KWOutput = ?,
        Item_Tank_Autonomy = ?,
        Item_Tank_Type = ?,
        CapacityGAL = ?,
        Cost = ?,
        Evaluator = ?,
        TechnicalSheet = ?
    WHERE ConfigID = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        cursor = conn.cursor()
        cursor.execute(query, (price, item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando Catálogo de componentes adicionales de tanques : {e}")
    finally:
        if conn:
            conn.close()

def searchitems():
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        cursor = conn.cursor()
        cursor.execute("SELECT ConfigID, TechnicalSheet FROM CZE_TankConfig")
        results = cursor.fetchall()
        if not results:  # Verifica si la tabla está vacía
            return []  # Devuelve una lista vacía si no hay datos
        return [{"ConfigID": row[0], "TechnicalSheet": row[1]} for row in results]
    
    except Exception as e:
        print(f"[Error] Buscando tanques: {str(e)}")
        return []
    finally:
        if conn:
            conn.close()

def update_Tank_TechnicalSheet(item,TechnicalSheet):
    """Actualiza solo la ficha técnica de un tanque."""
    query = """
    UPDATE CZE_TankConfig 
    SET TechnicalSheet = ? 
    WHERE ConfigID = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (TechnicalSheet,item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando Catálogo de componentes adicionales de tanques: {e}")
    finally:
        if conn:
            conn.close()