# Archivo: TestSQL.py
# Ruta: src/Consultas_SQL/Ventas/VentasEUA/DataMaster/TestSQL.py
# Propósito: Manejo de operaciones SQL para la tabla CZE_PrjWarTestConfig

from Consultas_SQL.conexion import get_connection

def get_Test():
    """Obtiene los Test desde la base de datos."""
    query = """
    SELECT
        ConfigID,
        Item_PrjWar_Testing,
        KWOutput,
        Cost,
        Evaluator,
        Document
    FROM
        CZE_PrjWarTestConfig
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query)
        results = cursor.fetchall()
        
        return [{
            "ConfigID": row[0],
            "Item_PrjWar_Testing": row[1],
            "KWOutput": float(row[2]) if row[2] else 0.0,
            "Cost": float(row[3]) if row[3] else 0.0,
            "Evaluator": row[4],
            "Document": row[5],
        } for row in results]
    except Exception as e:
        print(f"[Error inesperado] Error obteniendo Catálogo de componentes adicionales de plantas electricas : {e}")
        return []
    finally:
        if conn:
            conn.close()

def item_exists(item):
    conn = get_connection()
    try:  # Es una buena práctica usar un bloque try...finally para asegurar que la conexión se cierre.
        cursor = conn.cursor()
        cursor.execute("SELECT COUNT(*) FROM CZE_PrjWarTestConfig WHERE ConfigID = ?", (item,))
        result = cursor.fetchone()
        return result
    finally: # Esta parte es importante para cerrar la conexión sin importar si hay un error o no
        if conn:
            conn.close()


def update_Test(item, price):
    """Actualiza un Catálogo de componentes adicionales de casetas en la base de datos."""
    query = """
    UPDATE CZE_PrjWarTestConfig
    SET 
        Item_PrjWar_Testing = ?,
        KWOutput = ?,
        Cost = ?,
        Evaluator = ?,
        Document = ?
    WHERE ConfigID = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (price, item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando Catálogo de componentes adicionales de casetas : {e}")
    finally:
        if conn:
            conn.close()


def searchitems():
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        cursor = conn.cursor()
        cursor.execute("SELECT ConfigID, Document FROM CZE_PrjWarTestConfig WHERE Document IS NOT NULL")
        results = cursor.fetchall()
        if not results:  # Verifica si la tabla está vacía
            return []  # Devuelve una lista vacía si no hay datos

        return [{"ConfigID": row[0], "TechnicalSheet": row[1]} for row in results]
    
    except Exception as e:
        print(f"[Error inesperado] Error obteniendo items de Catálogo de componentes adicionales de casetas : {e}")
        return []
    finally:
        if conn:
            conn.close()


def update_Test_TechnicalSheet(item, TechnicalSheet):
    """Actualiza la ficha técnica de un componente de casetas en la base de datos."""    
    query = """
    UPDATE CZE_PrjWarTestConfig 
    SET Document = ? 
    WHERE ConfigID = ?
    """
    try:
        conn = get_connection()
        if not conn:
            raise ConnectionError("No se pudo establecer conexión con la base de datos")
        
        cursor = conn.cursor()
        cursor.execute(query, (TechnicalSheet, item))
        conn.commit()
    except Exception as e:
        print(f"[Error inesperado] Error actualizando ficha técnica de Catálogo de componentes adicionales de casetas: {e}")
    finally:
        if conn:
            conn.close()