# Archivo: conexion.py
# Ruta: src\Consultas_SQL\conexion.py
# Lenguaje: Python con Flask

import pyodbc  # Importa el módulo pyodbc
from flask import current_app  # Importa current_app de Flask

def get_connection():
    """Establece una conexión con la base de datos usando la configuración de Flask."""
    connection = None
    try:
        # Obtén la configuración desde current_app
        db_config = current_app.config.get('DB_CONFIG')
        if not db_config:
            raise ValueError("La configuración de DB_CONFIG no está definida en current_app.config")

        # Crea la cadena de conexión
        connection = pyodbc.connect(
            f'DRIVER={{ODBC Driver 17 for SQL Server}};'
            f'SERVER={db_config["server"]};'
            f'DATABASE={db_config["database"]};'
            f'UID={db_config["username"]};'
            f'PWD={db_config["password"]}'
        )
        return connection
    except ValueError as ve:
        print(f"Error de configuración: {ve}")
        return None
    except pyodbc.Error as e:
        print(f"Error al conectar con la base de datos: {e}")
        return None

def get_connectionERP():
    """Establece una conexión con la base de datos usando la configuración de Flask."""
    connection = None
    try:
        # Obtén la configuración desde current_app
        db_config = current_app.config.get('DB_CONFIG')
        if not db_config:
            raise ValueError("La configuración de DB_CONFIG no está definida en current_app.config")

        # Crea la cadena de conexión
        connection = pyodbc.connect(
            f'DRIVER={{ODBC Driver 17 for SQL Server}};'
            f'SERVER={db_config["server4"]};'
            f'DATABASE={db_config["database4"]};'
            f'UID={db_config["username4"]};'
            f'PWD={db_config["password4"]}'
        )
        return connection
    except ValueError as ve:
        print(f"Error de configuración: {ve}")
        return None
    except pyodbc.Error as e:
        print(f"Error al conectar con la base de datos: {e}")
        return None

def get_connectionbdproductivo():
    """Establece una conexión con la base de datos usando la configuración de Flask."""
    connection = None
    try:
        # Obtén la configuración desde current_app
        db_config = current_app.config.get('DB_CONFIG')
        if not db_config:
            raise ValueError("La configuración de DB_CONFIG no está definida en current_app.config")

        # Crea la cadena de conexión
        connection = pyodbc.connect(
            f'DRIVER={{ODBC Driver 17 for SQL Server}};'
            f'SERVER={db_config["server2"]};'
            f'DATABASE={db_config["database2"]};'
            f'UID={db_config["username2"]};'
            f'PWD={db_config["password2"]}'
        )
        return connection
    except ValueError as ve:
        print(f"Error de configuración: {ve}")
        return None
    except pyodbc.Error as e:
        print(f"Error al conectar con la base de datos: {e}")
        return None

def get_connectionTEST101():
    """Establece una conexión con la base de datos usando la configuración de Flask."""
    connection = None
    try:
        # Obtén la configuración desde current_app
        db_config = current_app.config.get('DB_CONFIG')
        if not db_config:
            raise ValueError("La configuración de DB_CONFIG no está definida en current_app.config")

        # Crea la cadena de conexión
        connection = pyodbc.connect(
            f'DRIVER={{ODBC Driver 17 for SQL Server}};'
            f'SERVER={db_config["server3"]};'
            f'DATABASE={db_config["database3"]};'
            f'UID={db_config["username3"]};'
            f'PWD={db_config["password3"]}'
        )
        return connection
    except ValueError as ve:
        print(f"Error de configuración: {ve}")
        return None
    except pyodbc.Error as e:
        print(f"Error al conectar con la base de datos: {e}")
        return None
