# 📘 Guía para Manejo de Traducciones en Flask

Esta guía describe el proceso para crear o actualizar traducciones en una aplicación Flask utilizando Babel.

## 🆕 Crear la Traducción de una Nueva Página

1. **Crear el archivo HTML**  
  Diseña la nueva página y marca los textos traducibles con:
  
  ```jinja
  {{ _('Texto traducible') }}
  ```
  
2. **Agregar a `babel.cfg`**  
  Incluye la ruta del nuevo archivo HTML en el archivo `babel.cfg` exactamente como está nombrado.
  
3. **Extraer cadenas traducibles**  
  Navega a la raíz del proyecto (por ejemplo, `PS I:\Elephant_D102\src>`) y ejecuta:
  
  ```bash
  pybabel extract -F babel.cfg -o messages.pot .
  ```
  
4. **Actualizar archivos `.po`**  
  Ejecuta:
  
  ```bash
  pybabel update -i messages.pot -d translations
  ```
  
5. **Traducir textos**  
  Abre el archivo `messages.po` del idioma y completa las traducciones.  
  Si encuentras líneas con `#, fuzzy`, asegúrate de validar su necesidad y elimina esa marca si es necesario esto puede estar evitando la traducccion de esa linea de texto.
  
6. **Compilar traducciones**  
  Ejecuta:
  
  ```bash
  pybabel compile -d translations
  ```
  
7. **Reiniciar Flask**  
  Reinicia la aplicación Flask para aplicar las nuevas traducciones.
  
8. **Verificar**  
  Abre la nueva página en el navegador y cambia el idioma para verificar que las traducciones funcionan correctamente.
  
---

## 🔄 Actualizar la Traducción de una Página Ya Traducida

1. **Verificar `babel.cfg`**  
  Asegúrate de que la página HTML esté incluida en el archivo `babel.cfg`. Si no está, sigue la sección anterior **"Crear la Traducción de una Nueva Página"**.
  
2. **Editar el HTML**  
  Realiza los cambios necesarios y asegúrate de marcar los textos traducibles con:
  
  ```jinja
  {{ _('Texto traducible') }}
  ```
  
3. **Extraer cadenas traducibles**  
  Navega a la raíz del proyecto (por ejemplo, `PS I:\Elephant_D102\src>`) y ejecuta:
  
  ```bash
  pybabel extract -F babel.cfg -o messages.pot .
  ```
  
4. **Actualizar archivos `.po`**  
  Ejecuta:
  
  ```bash
  pybabel update -i messages.pot -d translations
  ```
  
5. **Traducir textos**  
  Abre el archivo `messages.po` del idioma correspondiente y completa las traducciones.  
  Si encuentras líneas con `#, fuzzy`, asegúrate de validar su necesidad y elimina esa marca si es necesario esto puede estar evitando la traducccion de esa linea de texto.
  
6. **Compilar traducciones**  
  Ejecuta:
  
  ```bash
  pybabel compile -d translations
  ```
  
7. **Reiniciar Flask**  
  Reinicia la aplicación para cargar los cambios de traducción.
  
---