# Archivo: conexion.py
# Uso: Ejecutar para verificar conexión con SQL Server y consultar la tabla Division

import pyodbc

# CONFIGURACIÓN MANUAL (modificar según sea necesario)
server = '82.197.92.81'
database = 'TEST101'
username = 'user_test101'
password = 'N7#pWk!2rXeD9@uL'
driver = 'ODBC Driver 17 for SQL Server'

def get_connection():
    """Establece una conexión directa con SQL Server."""
    try:
        connection_string = (
            f'DRIVER={{{driver}}};'
            f'SERVER={server};'
            f'DATABASE={database};'
            f'UID={username};'
            f'PWD={password}'
        )
        connection = pyodbc.connect(connection_string)
        print("✅ Conexión exitosa a la base de datos.")
        return connection
    except pyodbc.Error as e:
        print(f"❌ Error al conectar con la base de datos: {e}")
        return None

def EJEMPLODECONSULTA():
    """Consulta la tabla 'Division' y muestra los resultados."""
    conn = get_connection()
    if conn is None:
        return

    try:
        cursor = conn.cursor()
        query = """
            SELECT 
                * 
            FROM 
                Division
        """
        cursor.execute(query)
        rows = cursor.fetchall()

        if not rows:
            print("⚠️ No se encontraron registros en la tabla 'Division'.")
        else:
            print("📋 Resultados de la tabla 'Division':")
            columns = [column[0] for column in cursor.description]
            print(" | ".join(columns))
            print("-" * 50)
            for row in rows:
                print(" | ".join(str(item) for item in row))

    except pyodbc.Error as e:
        print(f"❌ Error al consultar la tabla Division: {e}")
    finally:
        conn.close()

if __name__ == "__main__":
    EJEMPLODECONSULTA()
