Archivo: README.md
Ruta: src\README.md
Lenguaje: Texto

# 📦 IGSA Elephant – Plataforma Flask

Este proyecto está construido en **Python + Flask** y está diseñado para operar en dos entornos: **desarrollo** y **producción**, adaptándose automáticamente según lo definido en el archivo `.env`.

---
## 👥 Mi desarrollo y EPICOR

Este proyecto es desarrollado y mantenido por el área de Supervisión y Control de Operaciones de IGSA.

En el backend utilizamos Python y una base de datos en SQL Server, la cual administro directamente. El dominio del proyecto fue adquirido a través de Hostinger, donde también contraté un servicio de VPS que aloja la instancia de SQL Server.

El frontend y la comunicación con el backend están construidos con tecnologías como HTML, CSS y JavaScript.
Para integrar el proyecto con el ERP de la compañía (EPICOR), accedemos directamente a su base de datos con permisos de solo lectura, lo que nos permite ejecutar scripts de consulta que apoyan las operaciones del sistema.

---

## ⚙️ Instalación de dependencias

Ejecuta el siguiente comando desde la raíz del proyecto para instalar las dependencias necesarias:

```bash
pip install -r requirements.txt
```

---

## 🌍 Entornos: desarrollo y producción

El proyecto utiliza una variable de entorno para determinar el entorno de ejecución:

```env
FLASK_ENV=development  # O cambiar a production
```

Esta configuración controla:
- Las rutas y puertos del servidor
- La conexión a bases de datos
- La ubicación donde se guardan los archivos PDF generados
- El comportamiento general de debug/logging

### ▶️ Entorno de desarrollo (local):
```bash
python main.py
```
Esto correrá Flask en `localhost:5000` con recarga automática (`debug=True`).

### 🌐 Entorno de producción (en servidor VPS):
```bash
FLASK_ENV=production
python3 main.py
```
Esto usará `host=0.0.0.0` y un puerto como `4003`.

---

## 🛠️ Estructura del proyecto (resumen)

La estructura del proyecto sigue una **arquitectura modular orientada a menús funcionales**, con separación por capas (presentación, lógica y datos), diseñada en Flask, que permite escalar y mantener de forma clara y organizada la lógica de negocio de una plataforma empresarial.

Cada módulo representa un menú funcional de la aplicación:

- Clientes  
- Dirección  
- Ventas  
- Servicios  
- Operaciones  
- Supervisión y Control  

Cada uno se divide en:

- Lógica y rutas de negocio específicas por submenú (`*.py`)
- Acceso a datos (`ConsultasSQL`)
- Vistas (`templates`)
- Recursos estáticos (`static`)

```
Elephant_D102/
├── src/
│   ├── main.py           ← Punto de entrada
│   ├── app.py            ← Lógica y rutas de Flask
│   ├── config.py         ← Configuración por entorno
│   ├── .env              ← Variables sensibles
│   ├── requirements.txt  ← Archivo de dependencias externas (librerías y versiones específicas) 
│   ├── puppeteer_pdf/    ← Script generate_pdf.js (Puppeteer + Node.js)
│   ├── App/              ← Carpeta de aplicaciones desarrolladas y conectadas con app.py
│   │   ├── __init__.py   ← Archivo para definir los paquetes Python dentro de App hacia app.py (importaciones, variables globales, lógica de configuración)
│   │   ├── Utilidades.py       ← Archivo de conexión para pasar funciones de Utilidades_Module a app.py
│   │   ├── Utilidades_Module/  ← Carpeta de Aplicaciones de utilidades para consumo recurrente
│   │   │   ├── __init__.py     ← Archivo para definir los paquetes Python dentro de Utilidades_Module hacia Utilidades.py 
│   │   │   ├── DocsManagement.py               ← Lógica backend para manejo de archivos en la nube, recibe variables específicas
│   │   │   ├── EmailManagement.py              ← Lógica backend para envío de correos, recibe variables específicas
│   │   │   └── ...
│   │   ├── Security.py         ← Archivo de conexión para pasar funciones de Security_Module a app.py
│   │   ├── Security_Module/    ← Aplicaciones y lógica de seguridad (login, etc.)
│   │   │   ├── __init__.py     ← Archivo para definir los paquetes Python dentro de Security_Module hacia Security.py 
│   │   │   └── ...
│   │   ├── Clientes.py                     ← Archivo para renderizar el menú principal de clientes y la lógica del mismo HTML (src\templates\Clientes\Menuppal.html)
│   │   ├── Clientes_module/                ← Carpeta de Archivos de lógica backend desarrolladas para el menú de Clientes
│   │   │   ├── __init__.py                   ← Archivo para definir los paquetes Python dentro de Clientes_module hacia Clientes.py
│   │   │   ├── NetworkEnvironmentMenu.py     ← Archivo con la lógica del menú de Network Environment (src\templates\Clientes\NetworkEnvironment\Menu.html)
│   │   │   ├── NetworkEnvironment/           ← Carpeta de aplicaciones de lógica backend desarrolladas para el menú del cliente Network
│   │   │   │   ├── __init__.py                 ← Archivo para definir los paquetes Python dentro de NetworkEnvironment hacia NetworkEnvironmentMenu.py
│   │   │   │   ├── ScoreNetworkEnvironment.py  ← Lógica del Score de Plantas Eléctricas del cliente Network Environment
│   │   │   │   └── ...
│   │   │   └── ...
│   │   ├── Direccion.py               ← Archivo para renderizar el menú principal de Direccion y la lógica del mismo HTML (src\templates\Direccion\Menuppal.html)
│   │   ├── Direccion_module/          ← Carpeta de Aplicaciones para el menú de Direccion
│   │   │   ├── __init__.py            ← Archivo para definir los paquetes Python dentro de Direccion_module hacia Direccion.py
│   │   │   └── ...
│   │   ├── Ventas.py                  ← Archivo para renderizar el menú principal de Ventas y la lógica del mismo HTML (src\templates\Ventas\Menuppal.html)
│   │   ├── Ventas_module/             ← Carpeta de Aplicaciones para el menú de Ventas
│   │   │   ├── __init__.py            ← Archivo para definir los paquetes Python dentro de Ventas_module hacia Clientes.py
│   │   │   └── ...
│   │   ├── Servicios.py               ← Archivo para renderizar el menú principal de Servicios y la lógica del mismo HTML (src\templates\Servicios\Menuppal.html)
│   │   ├── Servicios_module/          ← Carpeta de Aplicaciones para el menú de Servicios
│   │   │   ├── __init__.py            ← Archivo para definir los paquetes Python dentro de Servicios_module hacia Clientes.py
│   │   │   └── ...
│   │   ├── Operaciones.py             ← Archivo para renderizar el menú principal de Operaciones y la lógica del mismo HTML (src\templates\Operaciones\Menuppal.html)
│   │   ├── Operaciones_module/        ← Carpeta de Aplicaciones para el menú de Operaciones
│   │   │   ├── __init__.py            ← Archivo para definir los paquetes Python dentro de Operaciones_module hacia Clientes.py
│   │   │   └── ...
│   │   ├── SupyCtrol.py               ← Archivo para renderizar el menú principal de SupyCtrol y la lógica del mismo HTML (src\templates\SupyCtrol\Menuppal.html)
│   │   ├── SupyCtrol_module/          ← Carpeta de Aplicaciones para el menú de Supervisión y Control
│   │   │   ├── __init__.py            ← Archivo para definir los paquetes Python dentro de SupyCtrol_module hacia Clientes.py
│   │   │   └── ...
│   │   └── ...
│   ├── ConsultasSQL/               ← Consultas y conexión a bases de datos (intermediarios entre lógica y base de datos)
│   │   ├── conexion.py               ← Configuracion de conexiones con las bases de datos SQL Server
│   │   ├── Utilidades/
│   │   │   ├── DocsManagementSQL.py            ← Archivo donde se manejan las Funciones SQL relacionadas con DocsManagement.py
│   │   │   ├── EmailManagementSQL.py           ← Archivo donde se manejan las Funciones SQL relacionadas con EmailManagement.py
│   │   │   └── ...
│   │   ├── Security/                 ← Carpeta de Archivos para manejo de SQL para el módulo de Seguridad
│   │   ├── Clientes/                 ← Carpeta de Archivos para manejo de SQL para el menú de Clientes
│   │   │   ├── NetworkEnvironment/             ← Carpeta de Archivos para manejo de SQL para el cliente Network Environment
│   │   │   │   ├── ScoreNetworkEnvironmentQL.py  ← Archivo donde se manejan las Funciones SQL relacionadas con ScoreNetworkEnvironment.py
│   │   │   │   └── ...
│   │   │   └── ...
│   │   ├── Direccion/                ← Carpeta de Archivos para manejo de SQL para el menú de Direccion
│   │   ├── Ventas/                   ← Carpeta de Archivos para manejo de SQL para el menú de Ventas
│   │   ├── Servicios/                ← Carpeta de Archivos para manejo de SQL para el menú de Servicios
│   │   ├── Operaciones/              ← Carpeta de Archivos para manejo de SQL para el menú de Operaciones
│   │   ├── SupyCtrol/                ← Carpeta de Archivos para manejo de SQL para el menú de Supervisión y Control
│   │   └── ...
│   └── templates/                          ← Plantillas HTML
│   │   ├── invex.html
│   │   ├── layout.html                       ← Layout base (header y footer; en el header esta el menú principal)
│   │   ├── welcome.html                      ← Html de bienvenida 
│   │   ├── Clientes/                         ← Carpeta de HTML desarrollados para el menú de Clientes
│   │   │   ├── Menuppal.html                   ← HTML del menú principal de clientes
│   │   │   ├── NetworkEnvironment/             ← Carpeta de HTML desarrollados para el cliente NetworkEnvironment
│   │   │   │   ├── Menu.html                     ← HTML del menú del cliente Network
│   │   │   │   ├── ScoreNetworkEnvironment.html  ← HTML del Score de Plantas Eléctricas del cliente NetworkEnvironment
│   │   │   │   └── ...
│   │   │   └── ...
│   │   ├── Direccion/                        ← Carpeta de HTML desarrollados para el menú de Direccion
│   │   ├── Ventas/                           ← Carpeta de HTML desarrollados para el menú de Ventas
│   │   └── ...
│   └── static/                             ← Archivos estáticos (JS, CSS, PDF, IMG, etc.)
│       ├── js/
│       │   ├── Clientes/                       ← Carpeta de JS desarrollados para el menú de Clientes
│       │   │   ├── Menuppal.js                   ← Si se necesitara un JS del menú principal de clientes, aquí se colocaría
│       │   │   ├── NetworkEnvironment/           ← Carpeta de JS desarrollados para el cliente NetworkEnvironment
│       │   │   │   ├── Menu.js                     ← Si se necesitara un JS del menú del cliente Network, aquí se colocaría
│       │   │   │   ├── ScoreNetworkEnvironment.js  ← JS del Score de Plantas Eléctricas del cliente NetworkEnvironment
│       │   │   │   └── ...
│       │   │   └── ...
│       │   ├── Direccion/                      ← Carpeta de JS desarrolladas para el menú de Direccion
│       │   ├── Ventas/                         ← Carpeta de JS desarrolladas para el menú de Ventas
│       │   ├── welcome.js                      ← JS de la pantalla de bienvenida
│       │   └── ...
│       ├── css/
│       │   ├── Clientes/                         ← Carpeta de CSS desarrollados para el menú de Clientes
│       │   │   ├── Menuppal.css                    ← Si se necesitara un CSS del menú principal de clientes, aquí se colocaría
│       │   │   ├── NetworkEnvironment/             ← Carpeta de CSS desarrollados para el cliente NetworkEnvironment
│       │   │   │   ├── Menu.css                      ← Si se necesitara un CSS del menú del cliente Network, aquí se colocaría
│       │   │   │   ├── ScoreNetworkEnvironment.css   ← CSS del Score de Plantas Eléctricas del cliente NetworkEnvironment
│       │   │   │   └── ...
│       │   │   └── ...
│       │   ├── Direccion/                        ← Carpeta de CSS desarrollados para el menú de Direccion
│       │   ├── Ventas/                           ← Carpeta de CSS desarrollados para el menú de Ventas
│       │   ├── welcome.css                       ← CSS de la pantalla de bienvenida
│       │   └── ...
│       ├── img/
│       │   ├── Clientes/                     ← Carpeta de imágenes usadas para el menú de Clientes
│       │   │   ├── Menuppal/                   ← Carpeta de imágenes usadas para el menú principal de clientes
│       │   │   ├── NetworkEnvironment/         ← Carpeta de imágenes desarrolladas para el cliente NetworkEnvironment
│       │   │   │   ├── Menu/                     ← Carpeta de imágenes usadas para el menú del cliente Network
│       │   │   │   ├── ScoreNetworkEnvironment/  ← Carpeta de imágenes usadas para el Score de Plantas Eléctricas del cliente NetworkEnvironment
│       │   │   │   └── ...
│       │   │   └── ...
│       │   ├── Direccion/                    ← Carpeta de imagenes usadas para el menú de Direccion
│       │   ├── Ventas/                       ← Carpeta de imagenes usadas para el menú de Ventas
│       │   ├── welcome/                      ← Carpeta de imagenes usadas para la pantalla de bienvenida
│       │   └── ...
│       └── ...
│   └── ...
└── ...
```
---

## 📁 Archivo `.env`: configuración de variables sensibles

Tenemos un archivo llamado `.env` dentro del directorio `src/` (donde está `config.py`), y definiron las siguientes variables:

```env
# ENTORNO
FLASK_ENV=development  # Cambiar a 'production' en el servidor

# BASE DE DATOS PRINCIPAL
DB_SERVER=xxx.xxx.xxx.xxx
DB_DATABASE=NombreBD
DB_USERNAME=usuario
DB_PASSWORD=contraseña
SECRET_KEY=clave_secreta_para_flask

# CONEXIONES ADICIONALES (opcionales)
DB_SERVER_2=...
DB_DATABASE_2=...
...

# CORREO ELECTRÓNICO (Flask-Mail)
MAIL_SERVER=smtp.office365.com
MAIL_PORT=587
MAIL_USE_TLS=True
MAIL_USERNAME=correo@igsa.com.mx
MAIL_PASSWORD=contraseña

# ONEDRIVE API (si aplica)
ONEDRIVE_CLIENT_ID=...
ONEDRIVE_CLIENT_SECRET=...
ONEDRIVE_REDIRECT_URI=https://tudominio.com
ONEDRIVE_USERNAME=...
ONEDRIVE_PASSWORD=...

# ARCHIVOS
UPLOAD_FOLDER=static/uploads/quotes
ALLOWED_EXTENSIONS=pdf,xlsx,docx,png,jpg,jpeg
MAX_CONTENT_LENGTH=16777216  # 16MB

# Configuración para subir archivos a la nube de hostinguer por FTP
FTP_HOST== ...
FTP_USER== ...
FTP_PASS== ...
```
---
# 🦾 Ayuda solicitada a IA

...