import os

# Archivos por extensión
def export_filtered_structure(directory, output_file, file_extension):
    """
    Exporta la estructura de directorios filtrada por una extensión específica, 
    incluyendo carpetas vacías si no contienen archivos con la extensión.

    Args:
        directory (str): Directorio raíz.
        output_file (str): Archivo de salida.
        file_extension (str): Extensión de archivo a filtrar (por ejemplo, '.py').
    """
    with open(output_file, 'w', encoding='utf-8') as f:
        for root, dirs, files in os.walk(directory):
            level = root.replace(directory, '').count(os.sep)
            indent = '│   ' * level + '├── '
            
            # Escribe el directorio actual (siempre)
            f.write(f"{indent}{os.path.basename(root)}/\n")
            
            # Filtra los archivos que coinciden con la extensión
            matching_files = [file for file in files if file.endswith(file_extension)]
            sub_indent = '│   ' * (level + 1) + '├── '
            
            # Escribe solo los archivos que coinciden
            for file in matching_files:
                f.write(f"{sub_indent}{file}\n")

# Cambia 'I:\\Elephant_D102\\src' por tu directorio raíz
export_filtered_structure(r'I:\Elephant_D102\src', 'estructura_filtrada_html.txt', '.html')


# Todo los Archivos
def export_all_structure(directory, output_file):
    """
    Exporta la estructura completa de directorios, incluyendo todos los archivos.

    Args:
        directory (str): Directorio raíz.
        output_file (str): Archivo de salida.
    """
    with open(output_file, 'w', encoding='utf-8') as f:
        for root, dirs, files in os.walk(directory):
            level = root.replace(directory, '').count(os.sep)
            indent = '│   ' * level + '├── '
            
            # Escribe el directorio actual
            f.write(f"{indent}{os.path.basename(root)}/\n")
            
            sub_indent = '│   ' * (level + 1) + '├── '
            
            # Escribe todos los archivos (sin filtrar)
            for file in files:
                f.write(f"{sub_indent}{file}\n")

# Uso de la función
export_all_structure(r'I:\Elephant_D102\src', 'estructura_completa.txt')


def export_directories_only(directory, output_file):
    """
    Exporta solo la estructura de directorios, excluyendo los archivos.

    Args:
        directory (str): Directorio raíz.
        output_file (str): Archivo de salida.
    """
    with open(output_file, 'w', encoding='utf-8') as f:
        for root, dirs, files in os.walk(directory):
            level = root.replace(directory, '').count(os.sep)
            indent = '│   ' * level + '├── '
            
            # Escribe solo los directorios
            f.write(f"{indent}{os.path.basename(root)}/\n")

# Uso de la función
export_directories_only(r'I:/Elephant_D102/src', 'solo_carpetas.txt')

def export_specific_files(directory, output_file, target_files):
    """
    Exporta la estructura de directorios mostrando solo archivos específicos.
    Args:
        directory (str): Directorio raíz.
        output_file (str): Archivo de salida.
        target_files (list o dict): Lista de nombres de archivos o diccionario con nombres de archivos.
        Si es dict, se usarán las claves como nombres de archivos.
    """
    # Convertir a lista si es un diccionario
    if isinstance(target_files, dict):
        files_to_find = list(target_files.keys())
    else:
        files_to_find = target_files
    
    # Diccionario para almacenar las rutas encontradas
    found_files = {}
    
    # Buscar los archivos en todo el directorio
    for root, dirs, files in os.walk(directory):
        for file in files:
            if file in files_to_find:
                if file not in found_files:
                    found_files[file] = []
                # Guardar la ruta completa relativa al directorio base
                relative_path = os.path.relpath(root, directory)
                found_files[file].append(relative_path)
    
    # Escribir resultados al archivo
    with open(output_file, 'w', encoding='utf-8') as f:
        f.write("=== ARCHIVOS USADOS EN ESTE DESARROLLO Y SUS FUNCIONES ===\n\n")
        
        for target_file in files_to_find:
            f.write(f"📁 {target_file}, Función: \n")
            
            if target_file in found_files:
                f.write(f"✅ Encontrado en {len(found_files[target_file])} ubicación(es):\n")
                
                for path in found_files[target_file]:
                    # Crear representación visual de la estructura
                    if path == '.':
                        f.write(f"├── {os.path.basename(directory)}/\n")
                        f.write(f"│   ├── {target_file}\n")
                    else:
                        # Dividir el path en partes para mostrar la jerarquía
                        path_parts = path.split(os.sep)
                        
                        # Mostrar la estructura jerárquica
                        f.write(f"├── {os.path.basename(directory)}/\n")
                        for i, part in enumerate(path_parts):
                            indent = "│   " * (i + 1)
                            f.write(f"{indent}├── {part}/\n")
                        
                        # Mostrar el archivo
                        final_indent = "│   " * (len(path_parts) + 1)
                        f.write(f"{final_indent}├── {target_file}\n")
                        
                        # Mostrar ruta completa
                        full_path = os.path.join(directory, path, target_file)
                        f.write(f"{final_indent}└── Ruta completa: {full_path}\n")
                    
                    f.write("\n")
            else:
                f.write("❌ No encontrado\n")
            
            f.write("-" * 50 + "\n\n")

target_files_list = [
    'GSYCManufacBOMIng.py',
    'GSYCManufacBOMIngSQL.py',
    'GSYCManufacBOMIng.js',
    'GSYCManufacBOMIng.html',
    'GSYCManufacBOMIng.css',
    'conexion.py',
    'config.py',
    'app.py',
    'main.py'
]

export_specific_files(r'I:\Elephant_D102\src', 'archivos_especificos.txt', target_files_list)