import os

def export_html_structure_with_indices(directory, output_file):
    """
    Exporta una tabla de los archivos HTML en la estructura de directorios,
    asignando índices jerárquicos (1, 1.1, 1.1.1, etc.).

    Args:
        directory (str): Directorio raíz.
        output_file (str): Archivo de salida.
    """
    # Lista para almacenar las entradas de la tabla
    table_entries = []
    
    # Función recursiva para procesar directorios
    def process_directory(current_dir, current_index_prefix=""):
        index_counter = 1
        
        # Obtener todos los directorios y archivos HTML
        items = os.listdir(current_dir)
        dirs = [item for item in items if os.path.isdir(os.path.join(current_dir, item))]
        html_files = [item for item in items if item.endswith('.html')]
        
        # Procesar archivos HTML en el directorio actual
        for html_file in sorted(html_files):
            index = f"{current_index_prefix}{index_counter}" if current_index_prefix else f"{index_counter}"
            file_path = os.path.join(current_dir, html_file)
            table_entries.append((index, html_file, file_path))
            index_counter += 1
        
        # Procesar subdirectorios
        for subdir in sorted(dirs):
            subdir_path = os.path.join(current_dir, subdir)
            
            # Verificar si hay archivos HTML en subdirectorios
            has_html = False
            for root, _, files in os.walk(subdir_path):
                if any(file.endswith('.html') for file in files):
                    has_html = True
                    break
            
            if has_html:
                # Crear el nuevo prefijo de índice
                new_index_prefix = f"{current_index_prefix}{index_counter}." if current_index_prefix else f"{index_counter}."
                # Procesar el subdirectorio recursivamente
                process_directory(subdir_path, new_index_prefix)
                index_counter += 1
    
    # Iniciar el procesamiento desde el directorio raíz
    process_directory(directory)
    
    # Escribir la tabla en el archivo de salida
    with open(output_file, 'w', encoding='utf-8') as f:
        f.write("Índice\tNombre\tRuta\n")
        f.write("-" * 100 + "\n")
        for index, name, path in table_entries:
            # Convertir la ruta relativa usando / en lugar de \ y eliminar "templates/"
            relative_path = os.path.relpath(path, directory)
            
            # Convertir barras invertidas a barras normales
            formatted_path = relative_path.replace("\\", "/")
            
            # Eliminar "templates/" si existe
            if "templates/" in formatted_path:
                formatted_path = formatted_path.replace("templates/", "")
            
            f.write(f"{index}\t{name}\t{formatted_path}\n")

# Cambia 'C:\\Elephant_D102\\src' por tu directorio raíz
export_html_structure_with_indices(r'C:\Elephant_D102\src', 'estructura_html_indices.txt')