# Archivo: main.py
# Ruta: src\main.py
# Descripción: Punto de entrada principal de la aplicación Flask
# Autor: Equipo de Desarrollo IGSA
# Fecha: 2025

import sys
import os

# Agregar la carpeta `src` al PYTHONPATH
current_dir = os.path.dirname(os.path.abspath(__file__))
src_dir = os.path.join(current_dir, 'src')
sys.path.append(src_dir)

# Importar configuraciones y la app
from config import Productivo, ENVIRONMENT
from app import create_app  # Asegúrate que app.py tenga esta función

# Crear la instancia de la aplicación con base en el entorno
app = create_app(ENVIRONMENT)

# Ejecutar la aplicación
if __name__ == "__main__":
    if Productivo:
        app.run(host="0.0.0.0", port=5000)
    else:
        app.run(debug=True)

