/*
Archivo: VEUcotizador.js
Ruta: src\puppeteer_pdf\Ventas\VentasEUA\VEUcotizador.js
Lenguaje: JavaScript
*/

const puppeteer = require('puppeteer');
const fs = require('fs');
const path = require('path');

// Ajusta esta ruta a la ubicación de tu logo
//const logoPath = path.join(__dirname, '..',  '..', '..','static', 'img', 'aDisenoGral', 'Logo Normal.png');
//const logoData = fs.readFileSync(logoPath);
//const base64Logo = Buffer.from(logoData).toString('base64');
//console.log(logoPath);
// console.log('data:image/png;base64,' + base64Logo);

(async () => {
    // Tomamos los argumentos de la línea de comandos
    const args = process.argv.slice(2);
    const url = args[0];         // URL del HTML a convertir
    const outputPath = args[1];  // Ruta donde guardar el PDF
    const token = args[2];       // Token único para identificar esta operación

    try {
        // Lanzamos el navegador
        const browser = await puppeteer.launch({
            headless: true,
            args: ['--no-sandbox']
        });
        
        const page = await browser.newPage();
        
        // Esperar a que las fuentes estén cargadas
        await page.evaluateHandle('document.fonts.ready');
        
        // Ir a la URL
        await page.goto(url, { waitUntil: 'networkidle0' });
        
        // Ocultar el botón "Send" antes de generar el PDF
        await page.evaluate(() => {
            const sendButton = document.querySelector('#sendButton');
            if (sendButton) sendButton.style.display = 'none';
            
            // También ocultamos el overlay si existe
            const overlay = document.querySelector('#loadingOverlay');
            if (overlay) overlay.style.display = 'none';
            
            // Ocultar el encabezado y pie de página HTML para que no aparezcan duplicados
            const headerHtml = document.querySelector('.header');
            if (headerHtml) headerHtml.style.display = 'none';
            
            const footerHtml = document.querySelector('.footer');
            if (footerHtml) footerHtml.style.display = 'none';
        });
        
        // Configuración para el PDF
        await page.pdf({
            path: outputPath,
            format: 'A4',
            printBackground: true,
            margin: {
                top: '1.7cm',    // Margen superior reducido
                right: '0.7cm',
                bottom: '1.5cm', // Margen inferior reducido
                left: '0.7cm'
            },
            displayHeaderFooter: true,
            headerTemplate: `
                <div style="width: 100%; padding: 0 10px; font-size: 9px; display: flex; justify-content: space-between; align-items: center; border-bottom: 1px solid #003366;">
                    <div style="display: flex; align-items: center;">
                        <!-- Logo usando SVG inline -->
                        <svg width="120" height="40" viewBox="0 0 120 40" style="margin-right: 10px;">
                            <rect width="240" height="40" fill="#003366"></rect>
                            <text x="50%" y="50%" dominant-baseline="middle" text-anchor="middle" fill="white" style="font-size: 14px; font-weight: bold;">IGSA POWER</text>
                        </svg>
                    </div>
                    <div style="text-align: right;">
                        <div style="font-weight: bold; font-size: 11px;">IGSA CORP</div>
                        <div>5918 SANTA MARIA AVE, LAREDO TEXAS 78041, USA | Tel: +19567914472</div>
                    </div>
                </div>
            `,
            footerTemplate: `
                <div style="width: 100%; padding: 5px 10px; font-size: 8px; border-top: 1px solid #dddddd; display: flex; justify-content: space-between; align-items: center;">
                    <div>IGSA CORP | Confidential Document</div>
                    <div>Página <span class="pageNumber"></span> de <span class="totalPages"></span></div>
                </div>
            `
        });
        
        await browser.close();
        console.log(JSON.stringify({ status: 'success', path: outputPath }));
    } catch (error) {
        console.error(JSON.stringify({ status: 'error', message: error.message }));
        process.exit(1);
    }
})();