// generate_pdf.js
const puppeteer = require('puppeteer');

(async () => {
    // Tomamos los argumentos de la línea de comandos
    const args = process.argv.slice(2);
    const flaskUrl = args[0];      // por ejemplo: http://127.0.0.1:5000/mi_html
    const outputPdfPath = args[1]; // por ejemplo: D:\PruebasPDF\prueba.pdf

    try {
        // Lanzamos el navegador con Puppeteer
        const browser = await puppeteer.launch({
            headless: true,
            args: ['--no-sandbox'] // Útil si estás en Linux/servidor. En Windows, también funciona.
        });

        const page = await browser.newPage();
        // Vamos a la URL del endpoint Flask
        await page.goto(flaskUrl, { waitUntil: 'networkidle0' });

        // Generamos el PDF en la ruta especificada
        await page.pdf({
            path: outputPdfPath,
            format: 'A4',
            printBackground: true
        });

        await browser.close();
        console.log("PDF generado correctamente en: " + outputPdfPath);
    } catch (error) {
        console.error("Error al generar PDF:", error);
        process.exit(1); // Indica error al proceso
    }
})();
