// Archivo: CotizEdit.js
// Ruta: src\static\js\Operaciones\Ingenieria\Cotiz\CotizEdit.js
// Lenguaje: JavaScript


//----------------------------
// --- DATATABLE COTIZ_EDIT --
//----------------------------

// Variable para la tabla
let cotizEditTable;

// Función para inicializar la tabla
function initializeCotizEditTable() {
    return $('#CotizEditTable').DataTable({
        responsive: true, // Hace la tabla responsiva
        scrollX: true,    // Permite scroll horizontal
        dom: 'Bfrtip',    // Define la disposición de los elementos (Botones, filtros, tabla, etc.)
        buttons: [        // Configuración de botones de exportación
            {
                extend: 'excel',
                text: 'Exportar a Excel',
                className: 'btn btn-success'
            },
            {
                extend: 'pdf',
                text: 'Exportar a PDF',
                className: 'btn btn-danger'
            }
        ],
        pageLength: 10,       // Número de registros por página por defecto
        ordering: true,       // Permite ordenar columnas
        searching: true,      // Habilita la búsqueda global
        lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "Todos"]],   // Opciones de cantidad de registros por página
        initComplete: function() {
            // Configurar búsqueda individual para cada columna
            this.api().columns().every(function() {
                var column = this;
                var header = $(column.header());
                var input = header.find('input');
                
                if (input.length) {
                    input.on('keyup change', function() {
                        if (column.search() !== this.value) {
                            column.search(this.value).draw();
                        }
                    });
                }
            });
        },
        columnDefs: [
            { 
                targets: -1,        // Aplica a la última columna
                orderable: false,   // Aplica para el ordenamiento
                searchable: false   // Aplica para la búsqueda
            }
        ],
        language: {
            url: "//cdn.datatables.net/plug-ins/1.10.25/i18n/Spanish.json"
        }
    });
}

// Función para cargar datos
function loadCotizEditData() {
    // Datos de ejemplo - En una aplicación real estos vendrían de una API
    const mockData = [
        {
        "No": "1013", 
        "Partnum": "Al3xis",      
        "Descripcion": "Descripción detallada del producto con características técnicas",      
        "Cantidad": "5",      
        "Unidad": "Pieza",      
        "Pin": "1234567890",      
        "Importe": "",      
        },
    ];

    // Obtiene referencia al cuerpo de la tabla
    const tableBody = document.getElementById("CotizEditbody");
    tableBody.innerHTML = "";   // Limpia el contenido actual

    // Itera sobre los datos y crea las filas de la tabla
    mockData.forEach(cotiz => {        
        const row = document.createElement("tr");
        row.innerHTML = `
            <td>${cotiz.No || '-'}</td>
            <td>${cotiz.Partnum || '-'}</td>
            <td>${cotiz.Descripcion || '-'}</td>
            <td>${cotiz.Cantidad || '-'}</td>
            <td>${cotiz.Unidad || '-'}</td>
            <td>${cotiz.Pin || '-'}</td>
            <td>${cotiz.Importe || '-'}</td>
            <td>
                <button class="btn-approve" onclick="approve('${cotiz.RequestID}')" title="Editar">
                   Editar                   
                </button>

                <button class="btn-reject" onclick="reject('${cotiz.RequestID}')" title="Eliminarr">
                   <i class="fa fa-trash" aria-hidden="true"></i>
                   <i class="bi bi-pencil"></i>
                </button>
            </td>
        `;
        tableBody.appendChild(row);
    });

    // Si ya existe una instancia de DataTable, la destruye antes de crear una nueva
    if (cotizEditTable) cotizEditTable.destroy();
    cotizEditTable = initializeCotizEditTable();   // Inicializa la nueva tabla
}

// Inicialización al cargar la página
$(document).ready(function() {
    loadCotizEditData();   // Carga los datos cuando el DOM está listo
});

// Función para editar
function editCotizEditItem(potencia) {
    console.log("Editar item con potencia:", potencia);
    // TODO: Implementar lógica de edición aquí
    // Esto podría abrir un modal con un formulario de edición
    // o navegar a una página de edición con los detalles del item
}