// Archivo: CZM_AlternatorModel.js
// Ruta: src\static\js\Operaciones\Ingenieria\PE\PE_DM\CZM_AlternatorModel.js
// Lenguaje: JavaScript



// NOTA HACERLE EL CAMBIO DEL NOMBRE DE LA TABLA YA QUE SE DEJO EL DE ApprovalAccessDistributorsTable
// CAMBIARLO POR EL DE CZM_ENGINEMODEL YA QUE LOS ENLACES QUE ESTAN CONECTAN A LA APP



// ===============================
// 🔹 CONSTANTES Y VARIABLES
// ===============================
const loadingIndicator = document.getElementById("loading-indicator"); // Indicador de carga
let table; // Variable para almacenar la instancia de DataTable
let selectedDistributorId = null; // ID del distribuidor seleccionado
let selectedDistributorIdForReject = null;

// ===============================
// 🔹 FUNCIONES GENÉRICAS
// ===============================

// Muestra el indicador de carga
function showLoading() {
    if (loadingIndicator) loadingIndicator.style.display = "block";
}

// Oculta el indicador de carga
function hideLoading() {
    if (loadingIndicator) loadingIndicator.style.display = "none";
}

function showGlobalLoading(message = "Procesando solicitud...") {
    // Actualizar el mensaje si es necesario
    document.querySelector("#global-loading-overlay .loading-text").textContent = message;
    
    // Mostrar el overlay
    document.getElementById("global-loading-overlay").style.display = "flex";
    
    // Bloquear el scroll
    document.body.style.overflow = "hidden";
}

function hideGlobalLoading() {
    // Ocultar el overlay
    document.getElementById("global-loading-overlay").style.display = "none";
    
    // Restaurar el scroll
    document.body.style.overflow = "auto";
}

// Modificar la función closeModal para resetear el modal al cerrarlo
function closeModal() {
    const modalElement = document.getElementById('EstandarModal');
    const modalInstance = bootstrap.Modal.getInstance(modalElement);
    if (modalInstance) {
        modalInstance.hide();
    }
    resetModal();
}

// Función para cerrar el modal de rechazo
function closeRejectModal() {
    const modalElement = document.getElementById('RejectModal');
    const modalInstance = bootstrap.Modal.getInstance(modalElement);
    if (modalInstance) {
        modalInstance.hide();
    }
    resetRejectModal();
}

// ===============================
// 🔹 FUNCIONES ESPECÍFICAS
// ===============================

// Inicializa la tabla DataTable con configuraciones específicas
function initializeDataTable() {
    return $('#ApprovalAccessDistributorsTable').DataTable({
        responsive: true,
        scrollX: true,
        dom: 'Bfrtip',
        buttons: [
            {
                extend: 'excel',
                text: 'Exportar a Excel',
                className: 'btn btn-success',
                exportOptions: {
                    columns: ':visible',
                    modifier: { page: 'all' },
                    format: {
                        header: function (data, columnIdx) {
                            let headerSelector = $('#ApprovalAccessDistributorsTable_wrapper .dataTables_scrollHead thead tr:nth-child(1) th');
                            if (headerSelector.length === 0) {
                                headerSelector = $('#ApprovalAccessDistributorsTable thead th');
                            }
                            return headerSelector.eq(columnIdx).text();
                        }
                    }
                }
            },
            {
                extend: 'pdf',
                text: 'Exportar a PDF',
                className: 'btn btn-danger',
                exportOptions: {
                    columns: ':visible',
                    modifier: { page: 'all' },
                    format: {
                        header: function (data, columnIdx) {
                            let headerSelector = $('#ApprovalAccessDistributorsTable_wrapper .dataTables_scrollHead thead tr:nth-child(1) th');
                            if (headerSelector.length === 0) {
                                headerSelector = $('#ApprovalAccessDistributorsTable thead th');
                            }
                            return headerSelector.eq(columnIdx).text();
                        }
                    }
                }
            }
        ],
        pageLength: 10,
        ordering: false,
        searching: true,
        lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "Todos"]],
        columnDefs: [
            { targets: -1, orderable: false, searchable: false }
        ],
        order: [[0, 'asc']]
    });
}


//-------------------- CARGA DE LOS DATOS--------------------
function loadAlternators() {
    showLoading();
    
    // Ejemplos completos de alternadores con todos los campos
    const exampleData = [
        {
            Voltaje: "208/120 V",
            Potencia: "Standby",
            Power_KW: "125",
            Power_KVA: "",
            Descripcion: ""
        },
        {
            Voltaje: "208/120 V", 
            Potencia: "Prime",
            Power_KW: "110",
            Power_KVA: "",
            Descripcion: ""
        },
        {
            Voltaje: "208/120 V",
            Potencia: "Continua",
            Power_KW: "90",
            Power_KVA: "",
            Descripcion: ""
        },
        {
            Voltaje: "600 V",
            Potencia: "Standby",
            Power_KW: "105",
            Power_KVA: "",
            Descripcion: ""
        },
        {
            Voltaje: "600 V",
            Potencia: "Prime",
            Power_KW: "90",
            Power_KVA: "", 
            Descripcion: ""
        },
        {
            Voltaje: "600 V",
            Potencia: "Continua",
            Power_KW: "75",
            Power_KVA: "",
            Descripcion: ""
        }
    ];

    // Simulando llamada a API con setTimeout
    setTimeout(() => {
        try {
            const tableBody = document.getElementById("ApprovalAccessDistributorsbody");
            tableBody.innerHTML = "";
            
            // EJEMPLO: Recorremos los datos de alternadores
            exampleData.forEach(alternator => {
                const row = document.createElement("tr");
                row.innerHTML = `
                    <td>${alternator.Voltaje || '-'}</td>
                    <td>${alternator.Potencia || '-'}</td>
                    <td>${alternator.Power_KW || '-'}</td>
                    <td>${alternator.Power_KVA || '-'}</td>
                    <td>${alternator.Descripcion || '-'}</td>
                    <td>
                        <button class="btn-approve" onclick="editAlternator('${alternator.ID}')" title="Editar">
                            Editar
                        </button>
                    </td>
                `;
                tableBody.appendChild(row);
            });

            if (table) table.destroy();
            table = initializeDataTable();
            
        } catch (error) {
            console.error("Error al cargar alternadores:", error);
            alert("Error al cargar datos de alternadores");
        } finally {
            hideLoading();
        }
    }, 800); // Simulamos retraso de red
    
    /* 
    // Versión con fetch real (descomentar cuando tengas el endpoint)
    fetch('/Ingenieria_Module/Alternators/list')
        .then(response => response.json())
        .then(data => {
            const tableBody = document.getElementById("CZM_AlternatorModelTablebody");
            tableBody.innerHTML = "";
            
            data.forEach(alternator => {
                const row = document.createElement("tr");
                row.innerHTML = `
                    <td>${alternator.Voltaje || ''}</td>
                    <td>${alternator.Potencia || ''}</td>
                    <td>${alternator.Power_KW || ''}</td>
                    <td>${alternator.Power_KVA || ''}</td>
                    <td>${alternator.Descripcion || ''}</td>
                    <td>
                        <button class="btn-approve" onclick="editAlternator('${alternator.ID}')" title="Editar">
                            <i class="fas fa-edit"></i> Editar
                        </button>
                    </td>
                `;
                tableBody.appendChild(row);
            });
            
            if (table) table.destroy();
            table = initializeDataTable();
        })
        .catch(error => {
            console.error("Error al cargar alternadores:", error);
            alert("Hubo un problema al cargar los alternadores. Intenta nuevamente.");
        })
        .finally(() => hideLoading());
    */
}

// Función para editar alternador (similar a approve() pero para alternadores)
function editAlternator(alternatorId) {
    selectedAlternatorId = alternatorId;
    
    // EJEMPLO: Datos del alternador seleccionado
    const alternatorData = {
        ID: alternatorId,
        Comments: alternatorId === "ALT-001" 
            ? "Alternador para uso general" 
            : "Alternador de alta potencia"
    };
    
    // Rellenar el modal (usando los mismos campos del original)
    document.getElementById('Comments').value = alternatorData.Comments;
    
    // Configurar select técnico (reutilizando sellerSelect)
    const techSelect = document.getElementById('sellerSelect');
    techSelect.innerHTML = `
        <option selected disabled value="">Seleccione técnico</option>
        <option value="TEC-01">Técnico Eléctrico</option>
        <option value="TEC-02">Técnico Mecánico</option>
    `;
    
    // Configurar valor técnico (reutilizando discountInput)
    document.getElementById('discountInput').value = "15";
    
    // Mostrar modal (el mismo que en el original)
    const modal = new bootstrap.Modal(document.getElementById('EstandarModal'));
    modal.show();
}

// Función para guardar cambios (similar a assignSeller())
function saveAlternatorChanges() {
    // Validación básica
    const techSelect = document.getElementById('sellerSelect');
    const techValue = document.getElementById('discountInput').value;
    
    if (!techSelect.value || isNaN(parseFloat(techValue))) {
        alert("Complete todos los campos requeridos");
        return;
    }
    
    // EJEMPLO: Mostrar datos que se enviarían
    const dataToSave = {
        alternatorId: selectedAlternatorId,
        technician: techSelect.value,
        techValue: parseFloat(techValue),
        comments: document.getElementById('Comments').value
    };
    
    console.log("Datos a guardar:", dataToSave);
    
    alert("Cambios guardados correctamente (ejemplo)");
    closeModal();
    loadAlternators();
}

// Inicialización
document.addEventListener("DOMContentLoaded", () => {
    loadAlternators();
    
    // Configurar botón de guardar
    document.querySelector('#EstandarModal .btn-primary').onclick = saveAlternatorChanges;
});

// Abre el modal para aprobar un distribuidor y cargar los vendedores
function approve(RequestID) {
    selectedDistributorId = RequestID;
    let modal = new bootstrap.Modal(document.getElementById('EstandarModal'));
    modal.show();
    loadSellers();
    loadDistributorComments(RequestID);
}


//----------------------------------------------------------------
//----------------------------------------------------------------



// Función para abrir el modal de rechazo y cargar los datos del distribuidor
function reject(requestId) {
    // Guardar el ID del distribuidor seleccionado para rechazo
    selectedDistributorIdForReject = requestId;
    
    // Mostrar indicador de carga
    showLoading();
    
    // Cargar los comentarios del distribuidor
    loadDistributorComments(requestId)
        .then(data => {
            // Asignar los comentarios del distribuidor al campo correspondiente
            document.getElementById('Comments2').value = data.Comments || '';
            
            // Mostrar el modal de rechazo
            const rejectModal = new bootstrap.Modal(document.getElementById('RejectModal'));
            rejectModal.show();
        })
        .catch(error => {
            console.error("Error al cargar comentarios:", error);
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'No se pudieron cargar los comentarios del distribuidor.',
                confirmButtonColor: '#d33',
                confirmButtonText: 'Aceptar'
            });
        })
        .finally(() => {
            hideLoading();
        });
}

// Carga la lista de vendedores desde el servidor y los muestra en el modal
function loadSellers() {
    // Muestra el indicador de carga si existe
    const loadingIndicator = document.getElementById('loading-indicator');
    if (loadingIndicator) {
        loadingIndicator.style.display = 'block';
    }
    
    // Obtiene el elemento select
    const sellerSelect = document.getElementById('sellerSelect');
    
    // Limpia las opciones existentes
    sellerSelect.innerHTML = '';
    
    // Agrega una opción por defecto
    const defaultOption = document.createElement('option');
    defaultOption.value = '';
    defaultOption.textContent = 'Seleccione un vendedor';
    defaultOption.selected = true;
    defaultOption.disabled = true;
    sellerSelect.appendChild(defaultOption);
    
    // Hace la petición a la API
    fetch('/Ventas_Module/VentasEUA/AccessDistributors/get_sellers')
        .then(response => {
            if (!response.ok) {
                throw new Error('Error en la respuesta del servidor: ' + response.status);
            }
            return response.json();
        })
        .then(data => {
            // Para cada vendedor recibido, crea una opción en el select
            data.forEach(seller => {
                const option = document.createElement('option');
                option.value = seller.UserID;
                option.textContent = seller.Seller;
                sellerSelect.appendChild(option);
            });
        })
        .catch(error => {
            console.error('Error al cargar los vendedores:', error);
            // Muestra un mensaje de error al usuario
            alert('Error al cargar la lista de vendedores. Por favor, intente nuevamente.');
        })
        .finally(() => {
            // Oculta el indicador de carga
            if (loadingIndicator) {
                loadingIndicator.style.display = 'none';
            }
        });
}

// Función para cargar los comentarios del distribuidor
function loadDistributorComments(RequestID) {
    // Mostrar el indicador de carga
    showLoading();
    
    // Crear una promesa para permitir un uso más flexible
    return new Promise((resolve, reject) => {
        // Hacer una petición para obtener los comentarios específicos del distribuidor
        fetch(`/Ventas_Module/VentasEUA/AccessDistributors/get_comments/${RequestID}`)
            .then(response => {
                if (!response.ok) {
                    throw new Error('Error al obtener los comentarios');
                }
                return response.json();
            })
            .then(data => {
                // Buscar el elemento para el modal de aprobación
                const approveCommentsElement = document.getElementById('Comments');
                
                // Si el elemento existe, mostrar los comentarios
                if (approveCommentsElement) {
                    approveCommentsElement.value = data.Comments || '';
                }
                
                // Buscar el elemento para el modal de rechazo
                const rejectCommentsElement = document.getElementById('Comments2');
                
                // Si el elemento existe, mostrar los comentarios
                if (rejectCommentsElement) {
                    rejectCommentsElement.value = data.Comments || '';
                }
                
                // Resolver la promesa con los datos
                resolve(data);
            })
            .catch(error => {
                console.error("Error al cargar los comentarios del distribuidor:", error);
                reject(error);
            })
            .finally(() => hideLoading());
    });
}

// Valida los campos requeridos en el modal antes de enviar el formulario
function validateForm() {
    let isValid = true;

    // Validar selección del vendedor
    let sellerSelect = document.getElementById("sellerSelect");
    if (!sellerSelect.value) {
        sellerSelect.classList.add("invalid-input");
        isValid = false;
    } else {
        sellerSelect.classList.remove("invalid-input");
    }

    // Validar el descuento
    let discountInput = document.getElementById("discountInput");
    if (discountInput.value.trim() === "" || isNaN(parseFloat(discountInput.value))) {
        discountInput.classList.add("invalid-input");
        isValid = false;
    } else {
        discountInput.classList.remove("invalid-input");
    }

    return isValid;
}

// Remueve el estado de error al corregir el input en tiempo real
document.getElementById("sellerSelect").addEventListener("change", function () {
    this.classList.remove("invalid-input");
});

document.getElementById("discountInput").addEventListener("input", function () {
    this.classList.remove("invalid-input");
});

// Aprueba el distribuidor, crea su cuenta de usuario y le asigna un vendedor
function assignSeller() {
    if (!validateForm()) {
        Swal.fire({
            icon: 'error',
            title: 'Campos obligatorios',
            text: 'Por favor, complete todos los campos obligatorios.',
            confirmButtonColor: '#d33',
            confirmButtonText: 'Aceptar'
        });
        return;
    }

    // Confirmar la acción antes de proceder
    Swal.fire({
        title: '¿Confirmar aprobación?',
        text: "Esta acción aprobará al distribuidor y creará su cuenta de usuario. ¿Desea continuar?",
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Sí, aprobar',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            // Mostrar indicador de carga global con mensaje específico
            showGlobalLoading("Procesando aprobación de distribuidor...");
            
            let sellerId = document.getElementById("sellerSelect").value;
            let discount = document.getElementById("discountInput").value;

            fetch('/Ventas_Module/VentasEUA/AccessDistributors/assign_seller', {
                method: "POST",
                headers: { "Content-Type": "application/json" },
                body: JSON.stringify({
                    distributorId: selectedDistributorId,
                    sellerId: sellerId,
                    discount: parseFloat(discount)
                })
            })
            .then(response => {
                if (!response.ok) {
                    return response.json().then(data => {
                        throw new Error(data.error || 'Error al procesar la solicitud');
                    });
                }
                return response.json();
            })
            .then(data => {
                // Ocultar indicador de carga global ANTES de mostrar el mensaje de Swal
                hideGlobalLoading();
                
                Swal.fire({
                    icon: 'success',
                    title: 'Distribuidor aprobado',
                    text: 'El distribuidor ha sido aprobado correctamente. Se ha creado su cuenta de usuario y se le ha asignado un vendedor.',
                    confirmButtonColor: '#3085d6',
                    confirmButtonText: 'Aceptar'
                }).then(() => {
                    closeModal();
                    window.location.reload();
                });
            })
            .catch(error => {
                // Ocultar indicador de carga global ANTES de mostrar el error
                hideGlobalLoading();
                
                console.error("Error al aprobar distribuidor:", error);
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: error.message || 'Hubo un problema al aprobar el distribuidor. Inténtelo de nuevo.',
                    confirmButtonColor: '#d33',
                    confirmButtonText: 'Aceptar'
                });
            });
        }
    });
}


//-----------------------------------------------------------------------
//-----------------------------------------------------------------------
//-----------------------------------------------------------------------


// Función para confirmar el rechazo del distribuidor
function confirmReject() {
    // Verificar que tengamos un ID de distribuidor seleccionado
    if (!selectedDistributorIdForReject) {
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'No se ha seleccionado un distribuidor para rechazar.',
            confirmButtonColor: '#d33',
            confirmButtonText: 'Aceptar'
        });
        return;
    }
    
    // Obtener el comentario de rechazo (opcional)
    const comentario = document.getElementById('Commentsresp').value.trim();
    
    // Mostrar confirmación antes de proceder
    Swal.fire({
        title: '¿Confirmar rechazo?',
        text: "Esta acción rechazará la solicitud del distribuidor. No se podrá deshacer.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Sí, rechazar',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            // Mostrar indicador de carga global con mensaje específico
            showGlobalLoading("Procesando rechazo de distribuidor...");
            
            // Enviar solicitud al servidor
            fetch('/Ventas_Module/VentasEUA/AccessDistributors/reject', {
                method: "POST",
                headers: { "Content-Type": "application/json" },
                body: JSON.stringify({
                    distributorId: selectedDistributorIdForReject,
                    comentario: comentario || null // Enviar null si no hay comentario
                })
            })
            .then(response => {
                if (!response.ok) {
                    return response.json().then(data => {
                        throw new Error(data.error || 'Error al procesar la solicitud');
                    });
                }
                return response.json();
            })
            .then(data => {
                // Ocultar indicador de carga global ANTES de mostrar el mensaje de Swal
                hideGlobalLoading();
                
                // Cerrar el modal
                closeRejectModal();
                
                if (data.error_mail) {
                    // El rechazo se completó pero hubo un problema con el correo
                    Swal.fire({
                        icon: 'warning',
                        title: 'Solicitud rechazada',
                        text: 'La solicitud ha sido rechazada, pero hubo un problema al enviar la notificación por correo electrónico.',
                        confirmButtonColor: '#3085d6',
                        confirmButtonText: 'Aceptar'
                    }).then(() => {
                        window.location.reload();
                    });
                } else {
                    // Todo se completó correctamente
                    Swal.fire({
                        icon: 'success',
                        title: 'Solicitud rechazada',
                        text: 'La solicitud del distribuidor ha sido rechazada y se ha enviado una notificación.',
                        confirmButtonColor: '#3085d6',
                        confirmButtonText: 'Aceptar'
                    }).then(() => {
                        window.location.reload();
                    });
                }
            })
            .catch(error => {
                // Ocultar indicador de carga global ANTES de mostrar el error
                hideGlobalLoading();
                
                console.error("Error al rechazar distribuidor:", error);
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: error.message || 'Hubo un problema al rechazar la solicitud. Inténtelo de nuevo.',
                    confirmButtonColor: '#d33',
                    confirmButtonText: 'Aceptar'
                });
            });
        }
    });
}

// Resetea los campos y estilos del modal cuando se cierra
function resetModal() {
    let sellerSelect = document.getElementById("sellerSelect");
    let discountInput = document.getElementById("discountInput");
    let commentsElement = document.getElementById("Comments");

    // Restablece el select
    sellerSelect.innerHTML = `<option selected disabled value="">Seleccione una opción</option>`;

    // Restablece el input de descuento
    discountInput.value = "0.00";

    // Limpiar el campo de comentarios
    if (commentsElement) {
        commentsElement.value = "";
    }

    // Elimina posibles estilos de error
    sellerSelect.classList.remove("invalid-input");
    discountInput.classList.remove("invalid-input");

    // Resetea la variable de RequestID seleccionado
    selectedDistributorId = null;
}

// Función para limpiar el modal de rechazo
function resetRejectModal() {
    // Limpiar los campos
    document.getElementById('Comments2').value = '';
    document.getElementById('Commentsresp').value = '';
    
    // Resetear el ID del distribuidor seleccionado
    selectedDistributorIdForReject = null;
}

// ===============================
// 🔹 EVENT LISTENERS
// ===============================

// Carga los distribuidores al cargar la página y agrega validaciones al campo de descuento
document.addEventListener("DOMContentLoaded", () => {
    loadDistributors();
    
    let discountInput = document.getElementById("discountInput");
    if (discountInput) {
        discountInput.addEventListener("blur", validateDiscount);
    }
});
document.getElementById('EstandarModal').addEventListener('hidden.bs.modal', resetModal);

// Inicializar eventos para el modal de rechazo cuando se carga el documento
document.addEventListener("DOMContentLoaded", () => {
    // Asignar evento al botón de confirmación de rechazo
    const confirmRejectBtn = document.getElementById('confirmRejectBtn');
    if (confirmRejectBtn) {
        confirmRejectBtn.addEventListener('click', confirmReject);
    }
    
    // Evento para limpiar el modal cuando se cierra
    document.getElementById('RejectModal').addEventListener('hidden.bs.modal', resetRejectModal);
});