// Archivo: CZM_GensetModel.js
// Ruta: src\static\js\Operaciones\Ingenieria\PE\PE_DM\CZM_GensetModel.js
// Lenguaje: JavaScript



// ===============================
// 🔹 FUNCIONES ESPECÍFICAS DATATABLE
// ===============================


// ===============================
// 🔹 CONSTANTES Y VARIABLES
// ===============================
const loadingIndicator = document.getElementById("loading-indicator"); // Indicador de carga
let table; // Variable para almacenar la instancia de DataTable
let selectedDistributorId = null; // ID del distribuidor seleccionado
let selectedDistributorIdForReject = null;

// ===============================
// 🔹 FUNCIONES GENÉRICAS
// ===============================

// Muestra el indicador de carga
function showLoading() {
    if (loadingIndicator) loadingIndicator.style.display = "block";
}

// Oculta el indicador de carga
function hideLoading() {
    if (loadingIndicator) loadingIndicator.style.display = "none";
}

function showGlobalLoading(message = "Procesando solicitud...") {
    // Actualizar el mensaje si es necesario
    document.querySelector("#global-loading-overlay .loading-text").textContent = message;
    
    // Mostrar el overlay
    document.getElementById("global-loading-overlay").style.display = "flex";
    
    // Bloquear el scroll
    document.body.style.overflow = "hidden";
}

function hideGlobalLoading() {
    // Ocultar el overlay
    document.getElementById("global-loading-overlay").style.display = "none";
    
    // Restaurar el scroll
    document.body.style.overflow = "auto";
}

// Modificar la función closeModal para resetear el modal al cerrarlo
function closeModal() {
    const modalElement = document.getElementById('EstandarModal');
    const modalInstance = bootstrap.Modal.getInstance(modalElement);
    if (modalInstance) {
        modalInstance.hide();
    }
    resetModal();
}

// Función para cerrar el modal de rechazo
function closeRejectModal() {
    const modalElement = document.getElementById('RejectModal');
    const modalInstance = bootstrap.Modal.getInstance(modalElement);
    if (modalInstance) {
        modalInstance.hide();
    }
    resetRejectModal();
}

// ===============================
// 🔹 FUNCIONES ESPECÍFICAS
// ===============================

// Inicializa la tabla DataTable con configuraciones específicas
function initializeDataTable() {
    return $('#ApprovalAccessDistributorsTable').DataTable({
        responsive: true,
        scrollX: true,
        dom: 'Bfrtip',
        buttons: [
            {
                extend: 'excel',
                text: 'Exportar a Excel',
                className: 'btn btn-success',
                exportOptions: {
                    columns: ':visible',
                    modifier: { page: 'all' },
                    format: {
                        header: function (data, columnIdx) {
                            let headerSelector = $('#ApprovalAccessDistributorsTable_wrapper .dataTables_scrollHead thead tr:nth-child(1) th');
                            if (headerSelector.length === 0) {
                                headerSelector = $('#ApprovalAccessDistributorsTable thead th');
                            }
                            return headerSelector.eq(columnIdx).text();
                        }
                    }
                }
            },
            {
                extend: 'pdf',
                text: 'Exportar a PDF',
                className: 'btn btn-danger',
                exportOptions: {
                    columns: ':visible',
                    modifier: { page: 'all' },
                    format: {
                        header: function (data, columnIdx) {
                            let headerSelector = $('#ApprovalAccessDistributorsTable_wrapper .dataTables_scrollHead thead tr:nth-child(1) th');
                            if (headerSelector.length === 0) {
                                headerSelector = $('#ApprovalAccessDistributorsTable thead th');
                            }
                            return headerSelector.eq(columnIdx).text();
                        }
                    }
                }
            }
        ],
        paging: false,  // ← Activar-Desactivar la paginación
        pageLength: 10,
        ordering: false,
        searching: true,
        lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "Todos"]],
        columnDefs: [
            { targets: -1, orderable: false, searchable: false }
        ],

        'rowsGroup': [0],

        order: [[0, 'asc']]
    });
}


//-------------------- CARGA DE LOS DATOS--------------------
function loadAlternators() {
    showLoading();
    
    // Ejemplos completos de alternadores con todos los campos
    const exampleData = [
        {"Voltaje": "228/120 3Ph 60Hz", "Potencia": "Standby",  "Power_kwCalculado": "93",  "Power_kwPropuesta": "80", "Power_kwCalculada": "", "Power_kwProducta": "", "ITEM": ""},
        {"Voltaje": "228/120 3Ph 60Hz", "Potencia": "Prime",    "Power_kwCalculado": "78",  "Power_kwPropuesta": "50", "Power_kwCalculada": "", "Power_kwProducta": "", "ITEM": ""},
        {"Voltaje": "228/120 3Ph 60Hz", "Potencia": "Continue", "Power_kwCalculado": "",    "Power_kwPropuesta": "",   "Power_kwCalculada": "", "Power_kwProducta": "", "ITEM": ""},

        {"Voltaje": "220/125 3Ph 60Hz", "Potencia": "Standby",  "Power_kwCalculado": "100", "Power_kwPropuesta": "100", "Power_kwCalculada": "", "Power_kwProducta": "", "ITEM": ""},
        {"Voltaje": "220/125 3Ph 60Hz", "Potencia": "Prime",    "Power_kwCalculado": "85",  "Power_kwPropuesta": "80",  "Power_kwCalculada": "", "Power_kwProducta": "", "ITEM": ""},
        {"Voltaje": "220/125 3Ph 60Hz", "Potencia": "Continue", "Power_kwCalculado": "",    "Power_kwPropuesta": "",    "Power_kwCalculada": "", "Power_kwProducta": "", "ITEM": ""},

        {"Voltaje": "240/138 3Ph 60Hz", "Potencia": "Standby",  "Power_kwCalculado": "106", "Power_kwPropuesta": "100", "Power_kwCalculada": "", "Power_kwProducta": "", "ITEM": ""},
        {"Voltaje": "240/138 3Ph 60Hz", "Potencia": "Prime",    "Power_kwCalculado": "90",  "Power_kwPropuesta": "80",  "Power_kwCalculada": "", "Power_kwProducta": "", "ITEM": ""},
        {"Voltaje": "240/138 3Ph 60Hz", "Potencia": "Continue", "Power_kwCalculado": "",    "Power_kwPropuesta": "",    "Power_kwCalculada": "", "Power_kwProducta": "", "ITEM": ""},

        {"Voltaje": "440/254 3Ph 60Hz", "Potencia": "Standby",  "Power_kwCalculado": "100", "Power_kwPropuesta": "100", "Power_kwCalculada": "", "Power_kwProducta": "", "ITEM": ""},
        {"Voltaje": "440/254 3Ph 60Hz", "Potencia": "Prime",    "Power_kwCalculado": "85",  "Power_kwPropuesta": "80",  "Power_kwCalculada": "", "Power_kwProducta": "", "ITEM": ""},
        {"Voltaje": "440/254 3Ph 60Hz", "Potencia": "Continue", "Power_kwCalculado": "",    "Power_kwPropuesta": "",    "Power_kwCalculada": "", "Power_kwProducta": "", "ITEM": ""},

        {"Voltaje": "460/265 3Ph 60Hz", "Potencia": "Standby",  "Power_kwCalculado": "100", "Power_kwPropuesta": "100", "Power_kwCalculada": "", "Power_kwProducta": "", "ITEM": ""},
        {"Voltaje": "460/265 3Ph 60Hz", "Potencia": "Prime",    "Power_kwCalculado": "85",  "Power_kwPropuesta": "80",  "Power_kwCalculada": "", "Power_kwProducta": "", "ITEM": ""},
        {"Voltaje": "460/265 3Ph 60Hz", "Potencia": "Continue", "Power_kwCalculado": "",    "Power_kwPropuesta": "",    "Power_kwCalculada": "", "Power_kwProducta": "", "ITEM": ""},

        {"Voltaje": "480/222 3Ph 60Hz", "Potencia": "Standby",  "Power_kwCalculado": "106", "Power_kwPropuesta": "100", "Power_kwCalculada": "", "Power_kwProducta": "", "ITEM": ""},
        {"Voltaje": "480/222 3Ph 60Hz", "Potencia": "Prime",    "Power_kwCalculado": "90",  "Power_kwPropuesta": "80",  "Power_kwCalculada": "", "Power_kwProducta": "", "ITEM": ""},
        {"Voltaje": "480/222 3Ph 60Hz", "Potencia": "Continue", "Power_kwCalculado": "",    "Power_kwPropuesta": "",    "Power_kwCalculada": "", "Power_kwProducta": "", "ITEM": ""},

        {"Voltaje": "308 3Ph 60Hz",     "Potencia": "Standby",  "Power_kwCalculado": "",    "Power_kwPropuesta": "",    "Power_kwCalculada": "", "Power_kwProducta": "", "ITEM": ""},
        {"Voltaje": "308 3Ph 60Hz",     "Potencia": "Prime",    "Power_kwCalculado": "",    "Power_kwPropuesta": "",    "Power_kwCalculada": "", "Power_kwProducta": "", "ITEM": ""},
        {"Voltaje": "308 3Ph 60Hz",     "Potencia": "Continue", "Power_kwCalculado": "",    "Power_kwPropuesta": "",    "Power_kwCalculada": "", "Power_kwProducta": "", "ITEM": ""},

        {"Voltaje": "600 3Ph 60Hz",     "Potencia": "Standby",  "Power_kwCalculado": "",    "Power_kwPropuesta": "",    "Power_kwCalculada": "", "Power_kwProducta": "", "ITEM": ""},
        {"Voltaje": "600 3Ph 60Hz",     "Potencia": "Prime",    "Power_kwCalculado": "",    "Power_kwPropuesta": "",    "Power_kwCalculada": "", "Power_kwProducta": "", "ITEM": ""},
        {"Voltaje": "600 3Ph 60Hz",     "Potencia": "Continue", "Power_kwCalculado": "",    "Power_kwPropuesta": "",    "Power_kwCalculada": "", "Power_kwProducta": "", "ITEM": ""},
    ];

    // Simulando llamada a API con setTimeout
    setTimeout(() => {
        try {
            const tableBody = document.getElementById("ApprovalAccessDistributorsbody");
            tableBody.innerHTML = "";
            
            // EJEMPLO: Recorremos los datos de alternadores
            exampleData.forEach(alternator => {
                const row = document.createElement("tr");
                row.innerHTML = `
                    <td>${alternator.Voltaje || '-'}</td>
                    <td>${alternator.Potencia || '-'}</td>
                    <td>${alternator.Power_kwCalculado || '-'}</td>
                    <td>${alternator.Power_kwPropuesta || '-'}</td>
                    <td>${alternator.Power_kwCalculada || '-'}</td>
                    <td>${alternator.Power_kwProducta || '-'}</td>
                    <td>${alternator.ITEM || '-'}</td>
                    <td>
                        <button class="btn-approve" onclick="editAlternator('${alternator.ID}')" title="Editar">
                            Editar
                        </button>
                    </td>
                `;
                tableBody.appendChild(row);
            });

            if (table) table.destroy();
            table = initializeDataTable();
            
        } catch (error) {
            console.error("Error al cargar alternadores:", error);
            alert("Error al cargar datos de alternadores");
        } finally {
            hideLoading();
        }
    }, 800); // Simulamos retraso de red
    
    /* 
    // Versión con fetch real (descomentar cuando tengas el endpoint)
    fetch('/Ingenieria_Module/Alternators/list')
        .then(response => response.json())
        .then(data => {
            const tableBody = document.getElementById("CZM_AlternatorModelTablebody");
            tableBody.innerHTML = "";
            
            data.forEach(alternator => {
                const row = document.createElement("tr");
                row.innerHTML = `
                    <td>${alternator.Voltaje || ''}</td>
                    <td>${alternator.Potencia || ''}</td>
                    <td>${alternator.Power_KW || ''}</td>
                    <td>${alternator.Power_KVA || ''}</td>
                    <td>${alternator.Descripcion || ''}</td>
                    <td>
                        <button class="btn-approve" onclick="editAlternator('${alternator.ID}')" title="Editar">
                            <i class="fas fa-edit"></i> Editar
                        </button>
                    </td>
                `;
                tableBody.appendChild(row);
            });
            
            if (table) table.destroy();
            table = initializeDataTable();
        })
        .catch(error => {
            console.error("Error al cargar alternadores:", error);
            alert("Hubo un problema al cargar los alternadores. Intenta nuevamente.");
        })
        .finally(() => hideLoading());
    */
}

// Función para editar alternador (similar a approve() pero para alternadores)
function editAlternator(alternatorId) {
    selectedAlternatorId = alternatorId;
    
    // EJEMPLO: Datos del alternador seleccionado
    const alternatorData = {
        ID: alternatorId,
        Comments: alternatorId === "ALT-001" 
            ? "Alternador para uso general" 
            : "Alternador de alta potencia"
    };
    
    // Rellenar el modal (usando los mismos campos del original)
    document.getElementById('Comments').value = alternatorData.Comments;
    
    // Configurar select técnico (reutilizando sellerSelect)
    const techSelect = document.getElementById('sellerSelect');
    techSelect.innerHTML = `
        <option selected disabled value="">Seleccione técnico</option>
        <option value="TEC-01">Técnico Eléctrico</option>
        <option value="TEC-02">Técnico Mecánico</option>
    `;
    
    // Configurar valor técnico (reutilizando discountInput)
    document.getElementById('discountInput').value = "15";
    
    // Mostrar modal (el mismo que en el original)
    const modal = new bootstrap.Modal(document.getElementById('EstandarModal'));
    modal.show();
}

// Función para guardar cambios (similar a assignSeller())
function saveAlternatorChanges() {
    // Validación básica
    const techSelect = document.getElementById('sellerSelect');
    const techValue = document.getElementById('discountInput').value;
    
    if (!techSelect.value || isNaN(parseFloat(techValue))) {
        alert("Complete todos los campos requeridos");
        return;
    }
    
    // EJEMPLO: Mostrar datos que se enviarían
    const dataToSave = {
        alternatorId: selectedAlternatorId,
        technician: techSelect.value,
        techValue: parseFloat(techValue),
        comments: document.getElementById('Comments').value
    };
    
    console.log("Datos a guardar:", dataToSave);
    
    alert("Cambios guardados correctamente (ejemplo)");
    closeModal();
    loadAlternators();
}

// Inicialización
document.addEventListener("DOMContentLoaded", () => {
    loadAlternators();
    
    // Configurar botón de guardar
    document.querySelector('#EstandarModal .btn-primary').onclick = saveAlternatorChanges;
});

// Abre el modal para aprobar un distribuidor y cargar los vendedores
function approve(RequestID) {
    selectedDistributorId = RequestID;
    let modal = new bootstrap.Modal(document.getElementById('EstandarModal'));
    modal.show();
    loadSellers();
    loadDistributorComments(RequestID);
}


//----------------------------------------------------------------
//----------------------------------------------------------------



// Función para abrir el modal de rechazo y cargar los datos del distribuidor
function reject(requestId) {
    // Guardar el ID del distribuidor seleccionado para rechazo
    selectedDistributorIdForReject = requestId;
    
    // Mostrar indicador de carga
    showLoading();
    
    // Cargar los comentarios del distribuidor
    loadDistributorComments(requestId)
        .then(data => {
            // Asignar los comentarios del distribuidor al campo correspondiente
            document.getElementById('Comments2').value = data.Comments || '';
            
            // Mostrar el modal de rechazo
            const rejectModal = new bootstrap.Modal(document.getElementById('RejectModal'));
            rejectModal.show();
        })
        .catch(error => {
            console.error("Error al cargar comentarios:", error);
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'No se pudieron cargar los comentarios del distribuidor.',
                confirmButtonColor: '#d33',
                confirmButtonText: 'Aceptar'
            });
        })
        .finally(() => {
            hideLoading();
        });
}

// Carga la lista de vendedores desde el servidor y los muestra en el modal
function loadSellers() {
    // Muestra el indicador de carga si existe
    const loadingIndicator = document.getElementById('loading-indicator');
    if (loadingIndicator) {
        loadingIndicator.style.display = 'block';
    }
    
    // Obtiene el elemento select
    const sellerSelect = document.getElementById('sellerSelect');
    
    // Limpia las opciones existentes
    sellerSelect.innerHTML = '';
    
    // Agrega una opción por defecto
    const defaultOption = document.createElement('option');
    defaultOption.value = '';
    defaultOption.textContent = 'Seleccione un vendedor';
    defaultOption.selected = true;
    defaultOption.disabled = true;
    sellerSelect.appendChild(defaultOption);
    
    // Hace la petición a la API
    fetch('/Ventas_Module/VentasEUA/AccessDistributors/get_sellers')
        .then(response => {
            if (!response.ok) {
                throw new Error('Error en la respuesta del servidor: ' + response.status);
            }
            return response.json();
        })
        .then(data => {
            // Para cada vendedor recibido, crea una opción en el select
            data.forEach(seller => {
                const option = document.createElement('option');
                option.value = seller.UserID;
                option.textContent = seller.Seller;
                sellerSelect.appendChild(option);
            });
        })
        .catch(error => {
            console.error('Error al cargar los vendedores:', error);
            // Muestra un mensaje de error al usuario
            alert('Error al cargar la lista de vendedores. Por favor, intente nuevamente.');
        })
        .finally(() => {
            // Oculta el indicador de carga
            if (loadingIndicator) {
                loadingIndicator.style.display = 'none';
            }
        });
}

// Función para cargar los comentarios del distribuidor
function loadDistributorComments(RequestID) {
    // Mostrar el indicador de carga
    showLoading();
    
    // Crear una promesa para permitir un uso más flexible
    return new Promise((resolve, reject) => {
        // Hacer una petición para obtener los comentarios específicos del distribuidor
        fetch(`/Ventas_Module/VentasEUA/AccessDistributors/get_comments/${RequestID}`)
            .then(response => {
                if (!response.ok) {
                    throw new Error('Error al obtener los comentarios');
                }
                return response.json();
            })
            .then(data => {
                // Buscar el elemento para el modal de aprobación
                const approveCommentsElement = document.getElementById('Comments');
                
                // Si el elemento existe, mostrar los comentarios
                if (approveCommentsElement) {
                    approveCommentsElement.value = data.Comments || '';
                }
                
                // Buscar el elemento para el modal de rechazo
                const rejectCommentsElement = document.getElementById('Comments2');
                
                // Si el elemento existe, mostrar los comentarios
                if (rejectCommentsElement) {
                    rejectCommentsElement.value = data.Comments || '';
                }
                
                // Resolver la promesa con los datos
                resolve(data);
            })
            .catch(error => {
                console.error("Error al cargar los comentarios del distribuidor:", error);
                reject(error);
            })
            .finally(() => hideLoading());
    });
}

// Valida los campos requeridos en el modal antes de enviar el formulario
function validateForm() {
    let isValid = true;

    // Validar selección del vendedor
    let sellerSelect = document.getElementById("sellerSelect");
    if (!sellerSelect.value) {
        sellerSelect.classList.add("invalid-input");
        isValid = false;
    } else {
        sellerSelect.classList.remove("invalid-input");
    }

    // Validar el descuento
    let discountInput = document.getElementById("discountInput");
    if (discountInput.value.trim() === "" || isNaN(parseFloat(discountInput.value))) {
        discountInput.classList.add("invalid-input");
        isValid = false;
    } else {
        discountInput.classList.remove("invalid-input");
    }

    return isValid;
}

// Remueve el estado de error al corregir el input en tiempo real
document.getElementById("sellerSelect").addEventListener("change", function () {
    this.classList.remove("invalid-input");
});

document.getElementById("discountInput").addEventListener("input", function () {
    this.classList.remove("invalid-input");
});

// Aprueba el distribuidor, crea su cuenta de usuario y le asigna un vendedor
function assignSeller() {
    if (!validateForm()) {
        Swal.fire({
            icon: 'error',
            title: 'Campos obligatorios',
            text: 'Por favor, complete todos los campos obligatorios.',
            confirmButtonColor: '#d33',
            confirmButtonText: 'Aceptar'
        });
        return;
    }

    // Confirmar la acción antes de proceder
    Swal.fire({
        title: '¿Confirmar aprobación?',
        text: "Esta acción aprobará al distribuidor y creará su cuenta de usuario. ¿Desea continuar?",
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Sí, aprobar',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            // Mostrar indicador de carga global con mensaje específico
            showGlobalLoading("Procesando aprobación de distribuidor...");
            
            let sellerId = document.getElementById("sellerSelect").value;
            let discount = document.getElementById("discountInput").value;

            fetch('/Ventas_Module/VentasEUA/AccessDistributors/assign_seller', {
                method: "POST",
                headers: { "Content-Type": "application/json" },
                body: JSON.stringify({
                    distributorId: selectedDistributorId,
                    sellerId: sellerId,
                    discount: parseFloat(discount)
                })
            })
            .then(response => {
                if (!response.ok) {
                    return response.json().then(data => {
                        throw new Error(data.error || 'Error al procesar la solicitud');
                    });
                }
                return response.json();
            })
            .then(data => {
                // Ocultar indicador de carga global ANTES de mostrar el mensaje de Swal
                hideGlobalLoading();
                
                Swal.fire({
                    icon: 'success',
                    title: 'Distribuidor aprobado',
                    text: 'El distribuidor ha sido aprobado correctamente. Se ha creado su cuenta de usuario y se le ha asignado un vendedor.',
                    confirmButtonColor: '#3085d6',
                    confirmButtonText: 'Aceptar'
                }).then(() => {
                    closeModal();
                    window.location.reload();
                });
            })
            .catch(error => {
                // Ocultar indicador de carga global ANTES de mostrar el error
                hideGlobalLoading();
                
                console.error("Error al aprobar distribuidor:", error);
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: error.message || 'Hubo un problema al aprobar el distribuidor. Inténtelo de nuevo.',
                    confirmButtonColor: '#d33',
                    confirmButtonText: 'Aceptar'
                });
            });
        }
    });
}


//-----------------------------------------------------------------------
//-----------------------------------------------------------------------
//-----------------------------------------------------------------------


// Función para confirmar el rechazo del distribuidor
function confirmReject() {
    // Verificar que tengamos un ID de distribuidor seleccionado
    if (!selectedDistributorIdForReject) {
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'No se ha seleccionado un distribuidor para rechazar.',
            confirmButtonColor: '#d33',
            confirmButtonText: 'Aceptar'
        });
        return;
    }
    
    // Obtener el comentario de rechazo (opcional)
    const comentario = document.getElementById('Commentsresp').value.trim();
    
    // Mostrar confirmación antes de proceder
    Swal.fire({
        title: '¿Confirmar rechazo?',
        text: "Esta acción rechazará la solicitud del distribuidor. No se podrá deshacer.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Sí, rechazar',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            // Mostrar indicador de carga global con mensaje específico
            showGlobalLoading("Procesando rechazo de distribuidor...");
            
            // Enviar solicitud al servidor
            fetch('/Ventas_Module/VentasEUA/AccessDistributors/reject', {
                method: "POST",
                headers: { "Content-Type": "application/json" },
                body: JSON.stringify({
                    distributorId: selectedDistributorIdForReject,
                    comentario: comentario || null // Enviar null si no hay comentario
                })
            })
            .then(response => {
                if (!response.ok) {
                    return response.json().then(data => {
                        throw new Error(data.error || 'Error al procesar la solicitud');
                    });
                }
                return response.json();
            })
            .then(data => {
                // Ocultar indicador de carga global ANTES de mostrar el mensaje de Swal
                hideGlobalLoading();
                
                // Cerrar el modal
                closeRejectModal();
                
                if (data.error_mail) {
                    // El rechazo se completó pero hubo un problema con el correo
                    Swal.fire({
                        icon: 'warning',
                        title: 'Solicitud rechazada',
                        text: 'La solicitud ha sido rechazada, pero hubo un problema al enviar la notificación por correo electrónico.',
                        confirmButtonColor: '#3085d6',
                        confirmButtonText: 'Aceptar'
                    }).then(() => {
                        window.location.reload();
                    });
                } else {
                    // Todo se completó correctamente
                    Swal.fire({
                        icon: 'success',
                        title: 'Solicitud rechazada',
                        text: 'La solicitud del distribuidor ha sido rechazada y se ha enviado una notificación.',
                        confirmButtonColor: '#3085d6',
                        confirmButtonText: 'Aceptar'
                    }).then(() => {
                        window.location.reload();
                    });
                }
            })
            .catch(error => {
                // Ocultar indicador de carga global ANTES de mostrar el error
                hideGlobalLoading();
                
                console.error("Error al rechazar distribuidor:", error);
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: error.message || 'Hubo un problema al rechazar la solicitud. Inténtelo de nuevo.',
                    confirmButtonColor: '#d33',
                    confirmButtonText: 'Aceptar'
                });
            });
        }
    });
}

// Resetea los campos y estilos del modal cuando se cierra
function resetModal() {
    let sellerSelect = document.getElementById("sellerSelect");
    let discountInput = document.getElementById("discountInput");
    let commentsElement = document.getElementById("Comments");

    // Restablece el select
    sellerSelect.innerHTML = `<option selected disabled value="">Seleccione una opción</option>`;

    // Restablece el input de descuento
    discountInput.value = "0.00";

    // Limpiar el campo de comentarios
    if (commentsElement) {
        commentsElement.value = "";
    }

    // Elimina posibles estilos de error
    sellerSelect.classList.remove("invalid-input");
    discountInput.classList.remove("invalid-input");

    // Resetea la variable de RequestID seleccionado
    selectedDistributorId = null;
}

// Función para limpiar el modal de rechazo
function resetRejectModal() {
    // Limpiar los campos
    document.getElementById('Comments2').value = '';
    document.getElementById('Commentsresp').value = '';
    
    // Resetear el ID del distribuidor seleccionado
    selectedDistributorIdForReject = null;
}

// ===============================
// 🔹 EVENT LISTENERS
// ===============================

// Carga los distribuidores al cargar la página y agrega validaciones al campo de descuento
document.addEventListener("DOMContentLoaded", () => {
    loadDistributors();
    
    let discountInput = document.getElementById("discountInput");
    if (discountInput) {
        discountInput.addEventListener("blur", validateDiscount);
    }
});
document.getElementById('EstandarModal').addEventListener('hidden.bs.modal', resetModal);

// Inicializar eventos para el modal de rechazo cuando se carga el documento
document.addEventListener("DOMContentLoaded", () => {
    // Asignar evento al botón de confirmación de rechazo
    const confirmRejectBtn = document.getElementById('confirmRejectBtn');
    if (confirmRejectBtn) {
        confirmRejectBtn.addEventListener('click', confirmReject);
    }
    
    // Evento para limpiar el modal cuando se cierra
    document.getElementById('RejectModal').addEventListener('hidden.bs.modal', resetRejectModal);
});



//----------------------------------------------------------------
// ---------------------- TABLA DE MOTOR -------------------------
//----------------------------------------------------------------


// Variable para la tabla
let motorTable;

// Función para inicializar la tabla

function initializeMotorTable() {
    return $('#MotorTable').DataTable({
        responsive: true,
        scrollX: true,
        dom: 'Bfrtip',
        buttons: [
            {
                extend: 'excel',
                text: 'Exportar a Excel',
                className: 'btn btn-success'
            },
            {
                extend: 'pdf',
                text: 'Exportar a PDF',
                className: 'btn btn-danger'
            }
        ],
        paging: false,  // ← Activar-Desactivar la paginación
        pageLength: 10,
        ordering: true,
        searching: true,
        lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "Todos"]],
        initComplete: function() {
            // Configurar búsqueda individual para cada columna
            this.api().columns().every(function() {
                var column = this;
                var header = $(column.header());
                var input = header.find('input');
                
                if (input.length) {
                    input.on('keyup change', function() {
                        if (column.search() !== this.value) {
                            column.search(this.value).draw();
                        }
                    });
                }
            });
        },
        order: [[1, 'desc']], //Ordena de mayor a menor
        columnDefs: [
            { 
                targets: -1, 
                orderable: false, 
                searchable: false 
            }
        ],
        language: {
            url: "//cdn.datatables.net/plug-ins/1.10.25/i18n/Spanish.json"
        }
    });
}

// Función para cargar datos
function loadMotorData() {
    showLoading();
    
    // Ejemplos completos de alternadores con todos los campos
    const mockData = [
        {"Potencia": "Standby",  "Power_kw": "115"},
        {"Potencia": "Prime",    "Power_kw": "105"},
        {"Potencia": "Continue", "Power_kw": ""   },
    ];


    const tableBody = document.getElementById("Motorbody");
    tableBody.innerHTML = "";

    mockData.forEach(item => {
        const row = document.createElement("tr");
        row.innerHTML = `
            <td>${item.Potencia || '-'}</td>
            <td>${item.Power_kw || '-'}</td>
        `;
        tableBody.appendChild(row);
    });

    if (motorTable) motorTable.destroy();
    motorTable = initializeMotorTable();
}

// Inicialización al cargar la página
$(document).ready(function() {
    loadMotorData();
});

// Función para editar
function editMotorItem(potencia) {
    console.log("Editar item con potencia:", potencia);
    // Tu lógica de edición aquí
}



//----------------------------------------------------------------
// ------------------- TABLA DE GENERADOR ------------------------
//----------------------------------------------------------------


// Variable para la tabla
let generadorTable;

// Función para inicializar la tabla
function initializeGeneradorTable() {
    return $('#GeneradorTable').DataTable({
        responsive: true,
        scrollX: true,
        dom: 'Bfrtip',
        buttons: [
            {
                extend: 'excel',
                text: 'Exportar a Excel',
                className: 'btn btn-success'
            },
            {
                extend: 'pdf',
                text: 'Exportar a PDF',
                className: 'btn btn-danger'
            }
        ],
        paging: false,  // ← Activar-Desactivar la paginación
        pageLength: 10,
        ordering: false,
        searching: true,
        lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "Todos"]],
        initComplete: function() {
            // Configurar búsqueda individual para cada columna
            this.api().columns().every(function() {
                var column = this;
                var header = $(column.header());
                var input = header.find('input');
                
                if (input.length) {
                    input.on('keyup change', function() {
                        if (column.search() !== this.value) {
                            column.search(this.value).draw();
                        }
                    });
                }
            });
        },
        order: [[1, 'desc']], //Ordena de mayor a menor
        columnDefs: [
            { 
                targets: -1, 
                orderable: false, 
                searchable: false 
            }
        ],
        language: {
            url: "//cdn.datatables.net/plug-ins/1.10.25/i18n/Spanish.json"
        },
        // Configuración de rowsGroup combinacion de columna parte (0)
        'rowsGroup': [0],
    });
}

// Función para cargar datos
function loadGeneradorData() {
    // Datos de ejemplo - agregué más datos para demostrar mejor la agrupación
    const mockData = [
        {"Voltaje": "228/120 3Ph 60Hz", "Potencia": "Standby",  "Power_kw": "93" },
        {"Voltaje": "228/120 3Ph 60Hz", "Potencia": "Continue", "Power_kw": "78" },

        {"Voltaje": "220/125 3Ph 60Hz", "Potencia": "Standby",  "Power_kw": "100"},
        {"Voltaje": "220/125 3Ph 60Hz", "Potencia": "Continue", "Power_kw": "85" },

        {"Voltaje": "240/138 3Ph 60Hz", "Potencia": "Standby",  "Power_kw": "106"},
        {"Voltaje": "240/138 3Ph 60Hz", "Potencia": "Continue", "Power_kw": "90" },

        {"Voltaje": "440/254 3Ph 60Hz", "Potencia": "Standby",  "Power_kw": "100"},
        {"Voltaje": "440/254 3Ph 60Hz", "Potencia": "Continue", "Power_kw": "85" },

        {"Voltaje": "460/265 3Ph 60Hz", "Potencia": "Standby",  "Power_kw": "100"},
        {"Voltaje": "460/265 3Ph 60Hz", "Potencia": "Continue", "Power_kw": "85" },

        {"Voltaje": "480/222 3Ph 60Hz", "Potencia": "Standby",  "Power_kw": "106"},
        {"Voltaje": "480/222 3Ph 60Hz", "Potencia": "Continue", "Power_kw": "90" },

        {"Voltaje": "308 3Ph 60Hz",     "Potencia": "Standby",  "Power_kw": ""   },
        {"Voltaje": "308 3Ph 60Hz",     "Potencia": "Continue", "Power_kw": ""   },

        {"Voltaje": "600 3Ph 60Hz",     "Potencia": "Standby",  "Power_kw": ""   },
        {"Voltaje": "600 3Ph 60Hz",     "Potencia": "Continue", "Power_kw": ""   },
    ];

    const tableBody = document.getElementById("Generadorbody");
    tableBody.innerHTML = "";

    mockData.forEach(item => {
        const row = document.createElement("tr");
        row.innerHTML = `
            <td>${item.Voltaje || '-'}</td>
            <td>${item.Potencia || '-'}</td>
            <td>${item.Power_kw || '-'}</td>
        `;
        tableBody.appendChild(row);
    });

    if (generadorTable) generadorTable.destroy();
    generadorTable = initializeGeneradorTable();
}

// Inicialización al cargar la página
$(document).ready(function() {
    // Necesitas incluir el CSS y JS del plugin rowsGroup
    // Agrega estos enlaces en tu HTML head:
    // <link rel="stylesheet" href="https://cdn.datatables.net/rowgroup/1.1.4/css/rowGroup.dataTables.min.css">
    // <script src="https://cdn.datatables.net/rowgroup/1.1.4/js/dataTables.rowGroup.min.js"></script>
    
    loadGeneradorData();
});

// Función para editar
function editGeneradorItem(potencia) {
    console.log("Editar item con potencia:", potencia);
    // Tu lógica de edición aquí
}



//----------------------------------------------------------------
// ---------------------- TABLA DE ABIERTO -----------------------
//----------------------------------------------------------------

// Variable para la tabla
let abiertoTable;

// Función para inicializar la tabla
function initializeAbiertoTable() {
    return $('#AbiertoTable').DataTable({
        responsive: true,
        scrollX: true,
        dom: 'Bfrtip',
        buttons: [
            {
                extend: 'excel',
                text: 'Exportar a Excel',
                className: 'btn btn-success'
            },
            {
                extend: 'pdf',
                text: 'Exportar a PDF',
                className: 'btn btn-danger'
            }
        ],
        pageLength: 10,
        ordering: true,
        searching: true,
        lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "Todos"]],
        initComplete: function() {
            // Configurar búsqueda individual para cada columna
            this.api().columns().every(function() {
                var column = this;
                var header = $(column.header());
                var input = header.find('input');
                
                if (input.length) {
                    input.on('keyup change', function() {
                        if (column.search() !== this.value) {
                            column.search(this.value).draw();
                        }
                    });
                }
            });
        },
        columnDefs: [
            { 
                targets: -1, 
                orderable: false, 
                searchable: false 
            }
        ],
        language: {
            url: "//cdn.datatables.net/plug-ins/1.10.25/i18n/Spanish.json"
        }
    });
}

// Función para cargar datos
function loadAbiertoData() {
    // Datos de ejemplo
    const mockData = [
        {"No_de_parte": "A-001", "Descripcion": "Base chasis"      },
        {"No_de_parte": "A-002", "Descripcion": "Base tque 1 pared"},
        {"No_de_parte": "A-003", "Descripcion": "Base tque 2 pared"},
    ];

    const tableBody = document.getElementById("Abiertobody");
    tableBody.innerHTML = "";

    mockData.forEach(item => {        
        const row = document.createElement("tr");
        row.innerHTML = `
            <td>${item.No_de_parte || '-'}</td>
            <td>${item.Descripcion || '-'}</td>
            <td>
                <button class="btn-approve" title="Eliminar">
                    Eliminar
                </button>
            </td>
        `;
        tableBody.appendChild(row);
    });

    if (abiertoTable) abiertoTable.destroy();
    abiertoTable = initializeAbiertoTable();
}

// Inicialización al cargar la página
$(document).ready(function() {
    loadAbiertoData();
});

// Función para editar
function editAbiertoItem(potencia) {
    console.log("Editar item con potencia:", potencia);
    // Tu lógica de edición aquí
}


//----------------------------------------------------------------
// ---------------------- TABLA DE CASETAS -----------------------
//----------------------------------------------------------------

// Variable para la tabla
let casetaTable;

// Función para inicializar la tabla
function initializeCasetaTable() {
    return $('#CasetaTable').DataTable({
        responsive: true,
        scrollX: true,
        dom: 'Bfrtip',
        buttons: [
            {
                extend: 'excel',
                text: 'Exportar a Excel',
                className: 'btn btn-success'
            },
            {
                extend: 'pdf',
                text: 'Exportar a PDF',
                className: 'btn btn-danger'
            }
        ],
        pageLength: 10,
        ordering: true,
        searching: true,
        lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "Todos"]],
        initComplete: function() {
            // Configurar búsqueda individual para cada columna
            this.api().columns().every(function() {
                var column = this;
                var header = $(column.header());
                var input = header.find('input');
                
                if (input.length) {
                    input.on('keyup change', function() {
                        if (column.search() !== this.value) {
                            column.search(this.value).draw();
                        }
                    });
                }
            });
        },
        columnDefs: [
            { 
                targets: -1, 
                orderable: false, 
                searchable: false 
            }
        ],
        language: {
            url: "//cdn.datatables.net/plug-ins/1.10.25/i18n/Spanish.json"
        }
    });
}

// Función para cargar datos
function loadCasetaData() {
    // Datos de ejemplo
    const mockData = [
        {"No_de_parte": "A-001", "Descripcion": "Caseta 100 KW",           "Certificacion": "No", "Material": "Acero",           "Proteccion": "N/A", "Nivel": "N/A"},
        {"No_de_parte": "A-002", "Descripcion": "Caseta Aluminio",         "Certificacion": "No", "Material": "Aluminio",        "Proteccion": "N/A", "Nivel": "N/A"},
        {"No_de_parte": "A-003", "Descripcion": "Caseta Acero inoxidable", "Certificacion": "No", "Material": "Acero inoxidable","Proteccion": "N/A", "Nivel": "N/A"},
    ];

    const tableBody = document.getElementById("Casetabody");
    tableBody.innerHTML = "";

    mockData.forEach(item => {        
        const row = document.createElement("tr");
        row.innerHTML = `
            <td>${item.No_de_parte || '-'}</td>
            <td>${item.Descripcion || '-'}</td>
            <td>${item.Certificacion || '-'}</td>
            <td>${item.Material || '-'}</td>
            <td>${item.Proteccion || '-'}</td>
            <td>${item.Nivel || '-'}</td>
            <td>
                <button class="btn-approve" title="Eliminar">
                    Eliminar
                </button>
            </td>
        `;
        tableBody.appendChild(row);
    });

    if (casetaTable) casetaTable.destroy();
    casetaTable = initializeCasetaTable();
}

// Inicialización al cargar la página
$(document).ready(function() {
    loadCasetaData();
});

// Función para editar
function editCasetaItem(potencia) {
    console.log("Editar item con potencia:", potencia);
    // Tu lógica de edición aquí
}