// Archivo: Casetas.js
// Ruta: src\static\js\Operaciones\Ingenieria\PE\PE_DM\Casetas.js
// Lenguaje: JavaScript


//----------------------------------------------------------------
// ---------------------- TABLA DE CASETA -----------------------
//----------------------------------------------------------------

// Variable para la tabla
let casetaTable;

// Función para inicializar la tabla
function initializeCasetaTable() {
    return $('#CasetaTable').DataTable({
        responsive: true,
        scrollX: true,
        dom: 'Bfrtip',
        buttons: [
            {
                extend: 'excel',
                text: 'Exportar a Excel',
                className: 'btn btn-success'
            },
            {
                extend: 'pdf',
                text: 'Exportar a PDF',
                className: 'btn btn-danger'
            }
        ],
        pageLength: 10,
        ordering: true,
        searching: true,
        lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "Todos"]],
        initComplete: function() {
            // Configurar búsqueda individual para cada columna
            this.api().columns().every(function() {
                var column = this;
                var header = $(column.header());
                var input = header.find('input');
                
                if (input.length) {
                    input.on('keyup change', function() {
                        if (column.search() !== this.value) {
                            column.search(this.value).draw();
                        }
                    });
                }
            });
        },
        columnDefs: [
            { 
                targets: -1, 
                orderable: false, 
                searchable: false 
            }
        ],
        language: {
            url: "//cdn.datatables.net/plug-ins/1.10.25/i18n/Spanish.json"
        }
    });
}

// Función para cargar datos
function loadCasetaData() {
    // Datos de ejemplo
    const mockData = [
        {"No_de_parte": "A-001", "Descripcion": "Base chasis"      },
        {"No_de_parte": "A-002", "Descripcion": "Base tque 1 pared"},
        {"No_de_parte": "A-003", "Descripcion": "Base tque 2 pared"},
    ];

    const tableBody = document.getElementById("Casetabody");
    tableBody.innerHTML = "";

    mockData.forEach(item => {        
        const row = document.createElement("tr");
        row.innerHTML = `
            <td>${item.No_de_parte || '-'}</td>
            <td>${item.Descripcion || '-'}</td>
            <td>
                <button class="btn-approve" title="Eliminar">
                    Eliminar
                </button>
            </td>
        `;
        tableBody.appendChild(row);
    });

    if (casetaTable) casetaTable.destroy();
    casetaTable = initializeCasetaTable();
}

// Inicialización al cargar la página
$(document).ready(function() {
    loadCasetaData();
});

// Función para editar
function editCasetaItem(potencia) {
    console.log("Editar item con potencia:", potencia);
    // Tu lógica de edición aquí
}