// Archivo: Switch_Box.js
// Ruta: src\static\js\Operaciones\Ingenieria\PE\PE_DM\Switch_Box.js
// Lenguaje: JavaScript


//----------------------------------------------------------------
// ----------- TABLA DE ARREGLO DE INGENIERIA PLANOS -------------
//----------------------------------------------------------------


// Variable para la tabla
let planosTable;

// Función para inicializar la tabla
function initializePlanosTable() {
    return $('#PlanosTable').DataTable({
        responsive: true,
        scrollX: true,
        dom: 'Bfrtip',
        buttons: [
            {
                extend: 'excel',
                text: 'Exportar a Excel',
                className: 'btn btn-success'
            },
            {
                extend: 'pdf',
                text: 'Exportar a PDF',
                className: 'btn btn-danger'
            }
        ],
        paging: true,  // ← Activar-Desactivar la paginación
        pageLength: 10,
        ordering: false,
        searching: true,
        lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "Todos"]],
        initComplete: function() {
            // Configurar búsqueda individual para cada columna
            this.api().columns().every(function() {
                var column = this;
                var header = $(column.header());
                var input = header.find('input');
                
                if (input.length) {
                    input.on('keyup change', function() {
                        if (column.search() !== this.value) {
                            column.search(this.value).draw();
                        }
                    });
                }
            });
        },
        order: [[1, 'desc']], //Ordena de mayor a menor
        columnDefs: [
            { 
                targets: -1, 
                orderable: false, 
                searchable: false 
            }
        ],        
        language: {
            url: "//cdn.datatables.net/plug-ins/1.10.25/i18n/Spanish.json"
        },        
        // Configuración de rowsGroup combinacion de columna 
        //'rowsGroup': [1],
    });
}

// Función para cargar datos
function loadPlanosData() {
    // Datos de ejemplo - agregué más datos para demostrar mejor la agrupación
    const mockData = [
        {"Nombre": "Pieza 1", "Familia": "Corte y doblez"  },
        {"Nombre": "Pieza 2", "Familia": "Corte y doblez"  },
        {"Nombre": "Pieza 3", "Familia": "Corte y doblez"  },

        {"Nombre": "Pieza 1", "Familia": "Archivo de corte"},
        {"Nombre": "Pieza 2", "Familia": "Archivo de corte"},
        {"Nombre": "Pieza 3", "Familia": "Archivo de corte"},

        {"Nombre": "Pieza 1", "Familia": "Soldadura"       },
        {"Nombre": "Pieza 2", "Familia": "Soldadura"       },
        {"Nombre": "Pieza 3", "Familia": "Soldadura"       },
    ];

    const tableBody = document.getElementById("Planosbody");
    tableBody.innerHTML = "";

    mockData.forEach(item => {
        const row = document.createElement("tr");
        row.innerHTML = `
            <td>${item.Nombre || '-'}</td>
            <td>${item.Familia || '-'}</td>
            <td>
                <button class="btn-edit" title="Editar">
                    Editar
                </button> 

                <button class="btn-delete" title="Eliminar">
                    Eliminar
                </button>
            </td>
        `;
        tableBody.appendChild(row);
    });

    if (planosTable) planosTable.destroy();
    planosTable = initializePlanosTable();
}

// Inicialización al cargar la página
$(document).ready(function() {
    // Necesitas incluir el CSS y JS del plugin rowsGroup
    // Agrega estos enlaces en tu HTML head:
    // <link rel="stylesheet" href="https://cdn.datatables.net/rowgroup/1.1.4/css/rowGroup.dataTables.min.css">
    // <script src="https://cdn.datatables.net/rowgroup/1.1.4/js/dataTables.rowGroup.min.js"></script>
    
    loadPlanosData();
});

// Función para editar
function editPlanosItem(potencia) {
    console.log("Editar item con potencia:", potencia);
    // Tu lógica de edición aquí
}