// Archivo: Transfer.js
// Ruta: src\static\js\Operaciones\Ingenieria\PE\PE_DM\Transfer.js
// Lenguaje: JavaScript



//----------------------------------------------------------------
// ---------------------- TABLA DE TRANSFERENCIA -----------------
//----------------------------------------------------------------



// Variable para la tabla
let transferTable;

// Función para inicializar la tabla
function initializeTransferTable() {
    return $('#TransferTable').DataTable({
        responsive: true,
        scrollX: true,
        dom: 'Bfrtip',
        buttons: [
            {
                extend: 'excel',
                text: 'Exportar a Excel',
                className: 'btn btn-success'
            },
            {
                extend: 'pdf',
                text: 'Exportar a PDF',
                className: 'btn btn-danger'
            }
        ],
        pageLength: 10,
        ordering: true,
        searching: true,
        lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "Todos"]],
        initComplete: function() {
            // Configurar búsqueda individual para cada columna
            this.api().columns().every(function() {
                var column = this;
                var header = $(column.header());
                var input = header.find('input');
                
                if (input.length) {
                    input.on('keyup change', function() {
                        if (column.search() !== this.value) {
                            column.search(this.value).draw();
                        }
                    });
                }
            });
        },
        columnDefs: [
            { 
                targets: -1, 
                orderable: false, 
                searchable: false 
            }
        ],
        language: {
            url: "//cdn.datatables.net/plug-ins/1.10.25/i18n/Spanish.json"
        }
    });
}

// Función para cargar datos
function loadTransferData() {
    // Datos de ejemplo
    const mockData = [
        {
        "Voltaje": "---", 
        "Capacidad AMP": "---"
        }
    ];

    const tableBody = document.getElementById("Transferbody");
    tableBody.innerHTML = "";

    mockData.forEach(item => {
        const row = document.createElement("tr");
        row.innerHTML = `
            <td>${item.Voltaje || '-'}</td>
            <td>${item.CapacidadAMP || '-'}</td>
            <td>
                <button class="btn-approve" title="Editar">
                    Editar
                </button>
            </td>
        `;
        tableBody.appendChild(row);
    });

    if (transferTable) transferTable.destroy();
    transferTable = initializeTransferTable();
}

// Inicialización al cargar la página
$(document).ready(function() {
    loadTransferData();
});

// Función para editar
function editTransferItem(potencia) {
    console.log("Editar item con potencia:", potencia);
    // Tu lógica de edición aquí
}