// Archivo: Universal_Board.js
// Ruta: src\static\js\Operaciones\Ingenieria\PE\PE_DM\Universal_Board.js
// Lenguaje: JavaScript


//----------------------------------------------------------------
// ---------------------- TABLA DE TABLERO UNIVERSAL -------------
//----------------------------------------------------------------


// Variable para la tabla
let capacidadTable;

// Función para inicializar la tabla
function initializeCapacidadTable() {
    return $('#CapacidadTable').DataTable({
        responsive: true,
        scrollX: true,
        dom: 'Bfrtip',
        buttons: [
            {
                extend: 'excel',
                text: 'Exportar a Excel',
                className: 'btn btn-success'
            },
            {
                extend: 'pdf',
                text: 'Exportar a PDF',
                className: 'btn btn-danger'
            }
        ],
        pageLength: 10,
        ordering: true,
        searching: true,
        lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "Todos"]],
        initComplete: function() {
            // Configurar búsqueda individual para cada columna
            this.api().columns().every(function() {
                var column = this;
                var header = $(column.header());
                var input = header.find('input');
                
                if (input.length) {
                    input.on('keyup change', function() {
                        if (column.search() !== this.value) {
                            column.search(this.value).draw();
                        }
                    });
                }
            });
        },
        columnDefs: [
            { 
                targets: -1, 
                orderable: false, 
                searchable: false 
            }
        ],
        language: {
            url: "//cdn.datatables.net/plug-ins/1.10.25/i18n/Spanish.json"
        }
    });
}

// Función para cargar datos
function loadCapacidadData() {
    // Datos de ejemplo
    const mockData = [
        {"Capacidad": "20"},
        {"Capacidad": "20"},
        {"Capacidad": "20"},
        {"Capacidad": "100"},
        {"Capacidad": "100"},
    ];

    const tableBody = document.getElementById("Capacidadbody");
    tableBody.innerHTML = "";

    mockData.forEach(item => {
        const row = document.createElement("tr");
        row.innerHTML = `
            <td>${item.Capacidad || '-'}</td>
            <td>
                <button class="btn-approve" title="Eliminar">
                    Eliminar
                </button>
            </td>
        `;
        tableBody.appendChild(row);
    });

    if (capacidadTable) capacidadTable.destroy();
    capacidadTable = initializeCapacidadTable();
}

// Inicialización al cargar la página
$(document).ready(function() {
    loadCapacidadData();
});

// Función para editar
function editCapacidadItem(potencia) {
    console.log("Editar item con potencia:", potencia);
    // Tu lógica de edición aquí
}