// Archivo: DMCompany.js
// Ruta: src\static\js\SupYCtrol\DataMaster\DMCompany.js
// Lenguaje: JavaScript

// Indicador de carga (debes agregarlo en el HTML)
const loadingIndicator = document.getElementById("loading-indicator");

// Función para mostrar el indicador de carga
function showLoading() {
    if (loadingIndicator) {
        loadingIndicator.style.display = "block";
    }
}

// Función para ocultar el indicador de carga
function hideLoading() {
    if (loadingIndicator) {
        loadingIndicator.style.display = "none";
    }
}

// Función para cargar compañías
function loadCompanies() {
    showLoading(); // Mostrar indicador de carga
    fetch('/SyC/data_master/companias/list')
        .then(response => response.json())
        .then(data => {
            const tableBody = document.getElementById("companyTableBody");
            tableBody.innerHTML = ""; // Limpiar la tabla
            data.forEach(company => {
                const row = document.createElement("tr");
                row.innerHTML = `
                    <td>${company.id}</td>
                    <td>${company.company}</td>
                    <td>${company.rfc}</td>
                    <td>${company.Entidad}</td>
                    <td>${company.Municipio}</td>
                    <td>${company.Colonia}</td>
                    <td>${company.Calle}</td>
                    <td>${company.Numero}</td>
                    <td>${company.CP}</td>
                    <td>${company.Telefono}</td>
                    <td>${company.Correo}</td>
                `;                 
                tableBody.appendChild(row);
            });
        })
        .catch(error => console.error("Error al cargar las compañías:", error))
        .finally(() => hideLoading()); // Ocultar indicador de carga
}

// Cargar compañías al cargar la página
document.addEventListener("DOMContentLoaded", loadCompanies);
