// Archivo: DMDepartament.js
// Ruta: src\static\js\SupYCtrol\DataMaster\DMDepartament.js
// Lenguaje: JavaScript

// Indicador de carga (debes agregarlo en el HTML)
const loadingIndicator = document.getElementById("loading-indicator");

// Función para mostrar el indicador de carga
function showLoading() {
    if (loadingIndicator) {
        loadingIndicator.style.display = "block";
    }
}

// Función para ocultar el indicador de carga
function hideLoading() {
    if (loadingIndicator) {
        loadingIndicator.style.display = "none";
    }
}

// Función para cargar compañías
function loadDepartament() {
    showLoading(); // Mostrar indicador de carga
    fetch('/SyC/data_master/departament/list')
        .then(response => response.json())
        .then(data => {
            const tableBody = document.getElementById("departamentTableBody");
            tableBody.innerHTML = ""; // Limpiar la tabla
            data.forEach(departament => {
                const row = document.createElement("tr");
                row.innerHTML = `
                    <td>${departament.DepartamentID}</td>
                    <td>${departament.departament}</td>
                    <td>${departament.CompanyID}</td>
                    <td>${departament.DivisionID}</td>

                `;                 
                tableBody.appendChild(row);
            });
        })
        .catch(error => console.error("Error al cargar los departamentos:", error))
        .finally(() => hideLoading()); // Ocultar indicador de carga
}

// Cargar compañías al cargar la página
document.addEventListener("DOMContentLoaded", loadDepartament);
