// Archivo: DMDivision.js
// Ruta: src\static\js\SupYCtrol\DataMaster\DMDivision.js
// Lenguaje: JavaScript

// Indicador de carga (debes agregarlo en el HTML)
const loadingIndicator = document.getElementById("loading-indicator");

// Función para mostrar el indicador de carga
function showLoading() {
    if (loadingIndicator) {
        loadingIndicator.style.display = "block";
    }
}

// Función para ocultar el indicador de carga
function hideLoading() {
    if (loadingIndicator) {
        loadingIndicator.style.display = "none";
    }
}

// Función para cargar compañías
function loadDivision() {
    showLoading(); // Mostrar indicador de carga
    fetch('/SyC/data_master/division/list')
        .then(response => response.json())
        .then(data => {
            const tableBody = document.getElementById("divisionTableBody");
            tableBody.innerHTML = ""; // Limpiar la tabla
            data.forEach(division => {
                const row = document.createElement("tr");
                row.innerHTML = `
                    <td>${division.DivisionID}</td>
                    <td>${division.division}</td>
                    <td>${division.CompanyID}</td>
                `;                 
                tableBody.appendChild(row);
            });
        })
        .catch(error => console.error("Error al cargar las divisiones:", error))
        .finally(() => hideLoading()); // Ocultar indicador de carga
}


// Cargar compañías al cargar la página
document.addEventListener("DOMContentLoaded", loadDivision);
