/*
Archivo: GSYCGetBomGenset.js
Ruta: src\static\js\SupYCtrol\GerenteSyC\UtilityMaterials\GSYCGetBomGenset.js
Lenguaje: JavaScript
*/

async function GSYCGetBomGenset() {
    // Obtener el valor del input
    const jobNum = document.getElementById('jobNum').value.trim();

    // Validar que el campo no esté vacío
    if (!jobNum) {
        alert("Por favor, ingresa un Job Number válido.");
        return;
    }

    try {
        // Llamada al endpoint; la ruta debe coincidir con la configurada en el backend
        const response = await fetch(`/api/get_bom?job_num=${encodeURIComponent(jobNum)}`);
        if (!response.ok) {
            throw new Error(`Error en la respuesta: ${response.status}`);
        }

        const data = await response.json();
        renderBOM(data);
    } catch (error) {
        console.error("Error al obtener el BOM:", error);
        alert("Ocurrió un error al obtener la trazabilidad del BOM.");
    }
}

function renderBOM(bomData) {
    const container = document.getElementById("resultsContainer");
    container.innerHTML = ""; // Limpiar contenido anterior

    // Contenedor con estilo nuevo
    const wrapper = document.createElement("div");
    wrapper.classList.add("bom-wide-table-container");

    // Crear tabla
    const table = document.createElement("table");
    table.classList.add("table", "table-bordered", "table-sm");

    // Encabezados
    table.innerHTML = `
        <thead class="thead-dark">
            <tr>
                <th>🔢 Nodo</th>
                <th>🧾 JobNum</th>
                <th>🔁 Seq</th>
                <th>🧩 PartNum</th>
                <th class="descripcion-col">📄 Descripción</th>
                <th>🏷️ Tipo</th>
                <th>📄 Revision</th>
                <th>📦 Qty Requerida</th>
                <th>📤 Qty Emitida</th>
                <th>✅ Completado</th>
                <th>💰 Cst. Material</th>
                <th>🛠️ Cst. Mano de Obra</th>
                <th>🏭 Cst. Gastos Gen.</th>
                <th>🧾 Cst. Subcontratos</th>
                <th>📦 Cst. Gen. De Mat.</th>
            </tr>
        </thead>
        <tbody id="bomTableBody"></tbody>
    `;
    

    // Agregar tabla al contenedor
    wrapper.appendChild(table);
    container.appendChild(wrapper);

    // Obtener tbody directamente desde la tabla
    const tbody = table.querySelector("tbody");

    // Procesar cada nodo raíz si es un array
    if (Array.isArray(bomData)) {
        bomData.forEach(node => renderBOMRowRecursive(node, tbody));
    } else {
        renderBOMRowRecursive(bomData, tbody);
    }

}

function renderBOMRowRecursive(node, tbody) {
    const row = document.createElement("tr");

    row.innerHTML = `
        <td>${node.Nodo || node.node_number || ""}</td>
        <td>${node.JobNum || ""}</td>
        <td>${node.Seq || ""}</td>
        <td>${node.PartNum || ""}</td>
        <td class="descripcion-col">${node.Descripcion || ""}</td>
        <td>${node.Tipo || ""}</td>
        <td>${node.Revision ?? node.RevisionNum ?? ""}</td>
        <td>${node.QtyRequerida ?? node.RequiredQty ?? node.ProdQty ?? ""}</td>
        <td>${node.QtyEmitida ?? node.IssuedQty ?? ""}</td>
        <td>${node.Completado !== undefined ? (node.Completado ? "✔️" : "❌") : ""}</td>
        <td>${node.TLAMaterialCost ?? ""}</td>
        <td>${node.TLALaborCost ?? ""}</td>
        <td>${node.TLABurdenCost ?? ""}</td>
        <td>${node.TLASubcontractCost ?? ""}</td>
        <td>${node.TLAMtlBurCost ?? ""}</td>
    `;

    tbody.appendChild(row);

    // Procesar hijos si existen
    if (node.children && Array.isArray(node.children)) {
        node.children.forEach(child => renderBOMRowRecursive(child, tbody));
    }
}
