// Optimized JavaScript Code
/**
 * DMEnclosureLoadCenter.js - Gestión de catálogo de controles
 * Ruta: src\static\js\Ventas\VentasEUA\DataMaster\DMEnclosureLoadCenter.js
 */

function agregarEstilosOverlay() {
    // Verificar si ya existe el estilo
    if (!document.getElementById('overlay-styles')) {
        const style = document.createElement('style');
        style.id = 'overlay-styles';
        style.innerHTML = `
            .page-overlay {
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background-color: rgba(0, 0, 0, 0.5);
                z-index: 9999;
                display: flex;
                justify-content: center;
                align-items: center;
                flex-direction: column;
            }
            .spinner-container {
                text-align: center;
                color: white;
            }
            .spinner-container .spinner-border {
                width: 3rem;
                height: 3rem;
            }
            .spinner-text {
                margin-top: 15px;
                font-size: 18px;
                font-weight: bold;
            }
        `;
        document.head.appendChild(style);
    }
}

function mostrarSpinner(mensaje = "Actualizando fichas técnicas...") {
    agregarEstilosOverlay();
    
    // Crear el overlay
    const overlay = document.createElement('div');
    overlay.className = 'page-overlay';
    overlay.id = 'actualizacion-overlay';
    
    // Crear el spinner y el mensaje
    overlay.innerHTML = `
        <div class="spinner-container">
            <div class="spinner-border text-light" role="status">
                <span class="visually-hidden">Cargando...</span>
            </div>
            <div class="spinner-text">${mensaje}</div>
        </div>
    `;
    
    // Agregar a la página
    document.body.appendChild(overlay);
    
    // Bloquear el scroll
    document.body.style.overflow = 'hidden';
}

function ocultarSpinner() {
    const overlay = document.getElementById('actualizacion-overlay');
    if (overlay) {
        overlay.remove();
        document.body.style.overflow = 'auto';
    }
}
// =====================================
// Configuración y Variables Globales
// =====================================
const CONFIG = {
    API_URL: '/ventas/data_master/Catalogo_de_centros_de_carga_para_casetas/listCatalogo_de_centros_de_carga_para_casetas',
    TABLA_ID: 'Catalogo_de_centros_de_carga_para_casetasTable',
    MONEDA: {
        estilo: 'currency',
        moneda: 'MXN',
        locale: 'es-MX'
    },
    DATATABLE: {
        columnDefs: [
            { targets: 0, width: "15%", className: 'text-center' },
            { targets: 1, width: "35%", className: 'text-left' },
            { targets: [2,3], width: "15%", className: 'text-center' },
            { targets: 5, width: "20%" }
        ]
    }
};

// =====================================
// Gestión del Indicador de Carga
// =====================================
const LoadingManager = {
    element: document.getElementById("loading-indicator"),
    
    show() {
        if (this.element) this.element.style.display = "block";
    },
    
    hide() {
        if (this.element) this.element.style.display = "none";
    }
};

// =====================================
//  Limpiar items
// =====================================
function limpiaritems() {
    document.getElementById("Item").value = "";
    document.getElementById("Description").value = "";
    document.getElementById("Price").value = "";
    document.getElementById("TechnicalSheet").value = "";
}

// =====================================
// Actualizar Fichas Tecnicas
// =====================================
async function actualizarfichastecnicas() {
    // Mostrar el spinner antes de iniciar la petición
    mostrarSpinner();
    try {
        const response = await fetch('/ventas/data_master/Catalogo_de_centros_de_carga_para_casetas/actualizarCatalogo_de_centros_de_carga_para_casetas', {
            method: 'GET',
            headers: {
                'Content-Type': 'application/json'
            }
        });

        // Agregar esto para depurar
        const responseData = await response.json();
        console.log("Respuesta del servidor:", responseData);
        // Ocultar el spinner una vez que hay respuesta
        ocultarSpinner();
        if (response.ok) {
            Swal.fire({
                title: "Actualizado!",
                text: "Los archivos se han actualizado exitosamente.",
                icon: "success"
            }).then(() => {
                location.reload(); // Recargar la página para actualizar la tabla
            });
        }
    } catch (error) {
        // Asegurarse de que el spinner se oculte incluso si hay un error
        ocultarSpinner();
        console.error("Error", error);
        Swal.fire({
            title: "Error!",
            text: "Ocurrió un error.",
            icon: "error"
        });
    }
}

// =====================================
// Gestión de la Tabla de Breakers
// =====================================
class Catalogo_de_centros_de_carga_para_casetas {
    constructor() {
        this.table = null;
        this.initializeTable();
    }

    async initializeTable() {
        LoadingManager.show();
        try {
            const data = await this.fetchBreakersData();
            this.renderTableData(data);
            this.initializeDataTable();
            this.setupEventListeners();
        } catch (error) {
            console.error("Error al inicializar la tabla:", error);
        } finally {
            LoadingManager.hide();
        }
    }

    async fetchBreakersData() {
        try {
            const response = await fetch(CONFIG.API_URL);
            const data = await response.json();
            console.log("Datos obtenidos:", data); // Verificar los datos recibidos
            return data;
        } catch (error) {
            console.error("Error al obtener los datos:", error);
            return [];
        }
    }

    renderTableData(data) {
        const tableBody = document.getElementById("TableBody");
        if (!tableBody) {
            console.error("No se encontró el elemento TableBody");
            return;
        }
        tableBody.innerHTML = data.map(breaker => this.createTableRow(breaker)).join('');
    }

    createTableRow(breaker) {
        // Verificación de datos para depuración
        if (!breaker) {
            console.error("Se recibió un registro nulo o indefinido");
            return "";
        }
        
        console.log("Procesando registro:", breaker);
        
        // Accede a las propiedades con los nombres correctos según el SQL
        let longitud = breaker.TechnicalSheet ? breaker.TechnicalSheet.length : 0;
        let icono;
    
        if (longitud > 0) {
            //icono = `<a href="/ventas/pdf_viewerCatalogo_de_centros_de_carga_para_casetas/view/${encodeURIComponent(breaker.TechnicalSheet)}" target="_blank"><i class="fas fa-file-pdf fa-2x" style="color:red; cursor: pointer;"></i></a>`;
            icono = `<a href="${breaker.TechnicalSheet}" target="_blank"><i class="fas fa-file-pdf fa-2x" style="color:red; cursor: pointer;"></i></a>`;
        } else {
            icono = '<i class="fas fa-file-pdf-o"></i>';
        }
        
        return `
            <tr>
                <td>${breaker.Item_Enclosure_LCenter}</td>
                <td>${breaker.description}</td>
                <td>${breaker.price}</td>
                <td>${icono}</td>
                <td>
                    <div class="btn-group">
                        <button type="button" class="btn btn-primary dm-btn-small editarCatalogo_de_centros_de_carga_para_casetas" 
                                data-bs-toggle="modal" data-bs-target="#editarCatalogo_de_centros_de_carga_para_casetasCatalog">
                            <i class="fas fa-edit"></i>
                            <span class="dm-btn-text">Editar</span>
                        </button>
                        <button type="button" class="btn btn-danger dm-btn-small ocultar-btn">
                            <i class="fas fa-trash"></i>
                            <span class="dm-btn-text">Eliminar</span>
                        </button>
                    </div>
                </td>
            </tr>
        `;
    }

    initializeDataTable() {
        if ($.fn.DataTable.isDataTable("#" + CONFIG.TABLA_ID)) {
            $('#' + CONFIG.TABLA_ID).DataTable().destroy();
        }

        this.table = $('#' + CONFIG.TABLA_ID).DataTable({
            dom: '<"d-flex justify-content-between align-items-center mb-2" Bf>rtip',
            buttons: [{
                extend: 'excel',
                text: '<i class="fas fa-file-excel"></i> Excel',
                className: 'btn btn-success dm-btn-xs dm-custom-excel-button'
            }],
            scrollX: true,
            autoWidth: true,
            ordering: false,
            fixedHeader: true,
            searching: true,
            columnDefs: [
                { targets: 0, width: "15%" },
                { targets: 1, width: "40%" },
                { targets: 2, width: "15%" },
                { targets: 3, width: "30%" },
                {
                    targets: 0,
                    className: 'text-center',
                },
                {
                    targets: 1,
                    className: 'text-left',
                },
                {
                    targets: 2,
                    className: 'text-center',
                    render: function(data, type, row) {
                        if (type === 'display' || type === 'filter') {
                            // Verificar si el dato es un número válido
                            const number = parseFloat(data);
                            if (!isNaN(number)) {
                                return new Intl.NumberFormat('es-MX', {
                                    style: 'currency',
                                    currency: 'MXN'
                                }).format(number);
                            } else {
                                return data; // Devolver el dato original si no es un número válido
                            }
                        }
                        return data;
                    }
                },
                {
                    targets: 3,
                    className: 'text-center',
                },
                {
                    targets: 4,
                    className: 'text-center',
                },
            ],
            language: {
                search: "Buscar:",
                lengthMenu: "Mostrar _MENU_ registros por página",
                info: "Mostrando _START_ a _END_ de _TOTAL_ registros",
                infoEmpty: "Mostrando 0 a 0 de 0 registros",
                paginate: {
                    first: "Primero",
                    last: "Último",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            }
        });
    }

    setupEventListeners() {
        // Filtros de columna
        $('.column-filter').on('keyup change', (e) => {
            const columnIndex = $(e.target).data('column');
            this.table.column(columnIndex).search(e.target.value).draw();
        });

        // Edición de registros
        $('#' + CONFIG.TABLA_ID).on('click', '.editarCatalogo_de_centros_de_carga_para_casetas', this.handleEdit);

        // Eliminación de registros
        $('#TableBody').on('click', '.ocultar-btn', this.handleDelete.bind(this));
    }

    handleEdit(e) {
        const row = e.target.closest('tr');
        if (!row) return;

        const [item, description, price, tipo] = Array.from(row.cells)
            .map((cell, index) => {
                const value = cell.textContent.trim();
                return index === 2 ? value.replace(/[^\d.-]/g, '') : value;
            });

        document.getElementById("ItemEdit").value = item;
        document.getElementById("DescriptionEdit").value = description;
        document.getElementById("PriceEdit").value = price;
    }

    async handleDelete(e) {
        const row = $(e.target).closest('tr');
        const item = row.find('td').eq(0).text().trim();
        
        const result = await Swal.fire({
            title: "¿Estás seguro de eliminar este item?",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Sí, eliminar!"
        });

        if (result.isConfirmed) {
            try {
                const response = await fetch('/ventas/data_master/Catalogo_de_centros_de_carga_para_casetas/deleteCatalogo_de_centros_de_carga_para_casetas', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({ item: item })
                });

                if (response.ok) {
                    row.fadeOut(500, () => { 
                        this.table.row(row).remove().draw();
                        Swal.fire({
                            title: "Eliminado!",
                            text: "El item ha sido eliminado.",
                            icon: "success"
                        });
                    });
                } else {
                    const errorData = await response.json();
                    Swal.fire({
                        title: "Error!",
                        text: errorData.error,
                        icon: "error"
                    });
                }
            } catch (error) {
                console.error("Error al eliminar:", error);
                Swal.fire({
                    title: "Error!",
                    text: "Ocurrió un error al eliminar",
                    icon: "error"
                });
            }
        }
    }
}

// =====================================
// Gestión de Modales
// =====================================
class ModalManager {
    static cerrarModalEditar() {
        const modal = document.getElementById("editarCatalogo_de_centros_de_carga_para_casetasCatalog");
        const modalInstance = bootstrap.Modal.getInstance(modal);
        
        if (modalInstance) {
            modalInstance.hide();
        }

        setTimeout(() => {
            document.querySelectorAll(".modal-backdrop").forEach(backdrop => backdrop.remove());
            document.body.classList.remove("modal-open");
            document.body.style.overflow = "auto";
        }, 300);
    }

    static validarFormulario(event) {
        const campos = [
            { id: "Item", mensaje: "El campo Item es obligatorio." },
            { id: "Description", mensaje: "El campo Descripción es obligatorio." },
            { id: "Price", mensaje: "El campo Precio es obligatorio." }
        ];

        let formularioValido = true;

        campos.forEach(campo => {
            const input = document.getElementById(campo.id);
            const valor = input.value.trim();
            let mensajeError = document.getElementById(`${campo.id}-error`);

            if (!mensajeError) {
                mensajeError = document.createElement("small");
                mensajeError.id = `${campo.id}-error`;
                mensajeError.style.color = "red";
                input.parentNode.appendChild(mensajeError);
            }

            if (!valor || valor === campo.invalidValue) {
                mensajeError.textContent = campo.mensaje;
                formularioValido = false;
            } else {
                mensajeError.textContent = "";
            }
        });

        if (!formularioValido) {
            event.preventDefault();
        }
    }
}

// =====================================
// Cerrar modal editar (función global para acceder desde el HTML)
// =====================================
function cerrarModalEditar() {
    ModalManager.cerrarModalEditar();
}

// =====================================
// Inicialización cuando el DOM está listo
// =====================================
document.addEventListener("DOMContentLoaded", () => {
    // Inicializar la tabla
    const breakersTableInstance = new Catalogo_de_centros_de_carga_para_casetas();
    
    // Agregar event listener para el botón de eliminar
    document.getElementById("TableBody").addEventListener("click", function(e) {
        if (e.target.classList.contains("ocultar-btn") || e.target.closest(".ocultar-btn")) {
            breakersTableInstance.handleDelete(e);
        }
    });
    
    // Agregar listener para el formulario de agregar
    const formAgregarCatalogo_de_centros_de_carga_para_casetas = document.getElementById("formAgregarCatalogo_de_centros_de_carga_para_casetas");
    if (formAgregarCatalogo_de_centros_de_carga_para_casetas) {
        formAgregarCatalogo_de_centros_de_carga_para_casetas.addEventListener("submit", async function(event) {
            event.preventDefault();
           
            const item = document.getElementById("Item").value.trim();
            const description = document.getElementById("Description").value.trim();
            const price = document.getElementById("Price").value.trim();
            const technicalSheet = document.getElementById("TechnicalSheet").files;
            const formData = new FormData();
            
            formData.append('item', item);
            formData.append('description', description);
            formData.append('price', price);

            // Validar y añadir el archivo PDF si existe
            if (technicalSheet.length > 0) {
                if (!technicalSheet[0].name.toLowerCase().endsWith('.pdf')) {
                    Swal.fire({
                        title: "Error!",
                        text: "Por favor selecciona un archivo PDF.",
                        icon: "error"
                    });
                    return;
                }
                formData.append('TechnicalSheet', technicalSheet[0]);
            }
            
            // Mostrar el spinner antes de iniciar la petición
            mostrarSpinner();
            
            try {
                const response = await fetch('/ventas/data_master/brakers/addCatalogo_de_centros_de_carga_para_casetas', {
                    method: 'POST',
                    body: formData
                });
                
                // Ocultar el spinner una vez que hay respuesta
                ocultarSpinner();
                
                if (response.ok) {
                    Swal.fire({
                        title: "Guardado!",
                        text: "El Catálogo de centros de carga para casetas  ha sido guardado exitosamente.",
                        icon: "success"
                    }).then(() => {
                        // Limpiar todas las cajas de texto
                        limpiaritems();
                        location.reload(); // Recargar la página para actualizar la tabla
                    });
                } else {
                    const errorData = await response.json();
                    Swal.fire({
                        title: "Error!",
                        text: errorData.error,
                        icon: "error"
                    });
                }
            } catch (error) {
                // Ocultar el spinner una vez que hay respuesta
                ocultarSpinner();
                console.error("Error al guardar :", error);
                Swal.fire({
                    title: "Error!",
                    text: "Ocurrió un error al guardar .",
                    icon: "error"
                });
            }
        });
    }

    // Agregar listener para el formulario de editar
    const formEditarCatalogo_de_centros_de_carga_para_casetas = document.getElementById("formEditarCatalogo_de_centros_de_carga_para_casetas");
    if (formEditarCatalogo_de_centros_de_carga_para_casetas) {
        formEditarCatalogo_de_centros_de_carga_para_casetas.addEventListener("submit", async function(event) {
            event.preventDefault();

            const item = document.getElementById("ItemEdit").value.trim();
            const description = document.getElementById("DescriptionEdit").value.trim();
            const price = document.getElementById("PriceEdit").value.trim();

            const data = {
                item: item,
                description: description,
                price: price
            };

            try {
                const response = await fetch('/ventas/data_master/updateCatalogo_de_centros_de_carga_para_casetas', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(data)
                });

                if (response.ok) {
                    Swal.fire({
                        title: "Actualizado!",
                        text: "El Catálogo de centros de carga para casetas ha sido actualizado exitosamente.",
                        icon: "success"
                    }).then(() => {
                        location.reload(); // Recargar la página para actualizar la tabla
                    });
                } else {
                    const errorData = await response.json();
                    Swal.fire({
                        title: "Error!",
                        text: errorData.error,
                        icon: "error"
                    });
                }
            } catch (error) {
                console.error("Error al actualizar :", error);
                Swal.fire({
                    title: "Error!",
                    text: "Ocurrió un error al actualizar .",
                    icon: "error"
                });
            }
        });
    }

    // Corregir el atributo form en el botón de actualizar
    const formEditarBtn = document.querySelector("button[form='formEditarCatalogo_de_centros_de_carga_para_casetas']");
    if (formEditarBtn) {
        formEditarBtn.setAttribute("form", "formEditarCatalogo_de_centros_de_carga_para_casetas");
    }

    // Limpieza de modal
    const modalElement = document.getElementById("editarCatalogo_de_centros_de_carga_para_casetasCatalog");
    if (modalElement) {
        modalElement.addEventListener("hidden.bs.modal", ModalManager.cerrarModalEditar);
    }
});