import { EventEmitter } from '../../../stencil-public-runtime';
export declare class UploadFileComponent {
    moduleName: string;
    fileType: string;
    displayName: string;
    maxFileSize: number | string;
    allowedExtensions: string | string[];
    selectedFiles: Map<number, {
        id: number;
        file: File;
        addedAt: string;
    }>;
    fileCounter: number;
    private fileInputRef?;
    private _allowedExtArr;
    private _maxFileSizeNum;
    componentWillLoad(): void;
    filesSelected: EventEmitter<{
        files: Array<{
            id: number;
            file: File;
            addedAt: string;
        }>;
        plainFiles: File[];
        totalSize: number;
        count: number;
        reason: 'add' | 'remove' | 'clear';
    }>;
    filesChanged: EventEmitter<{
        files: Array<{
            id: number;
            file: File;
            addedAt: string;
        }>;
        plainFiles: File[];
        totalSize: number;
        count: number;
    }>;
    getSelectedFiles(): Promise<File[]>;
    getSelectedFileObjects(): Promise<Array<{
        id: number;
        file: File;
        addedAt: string;
    }>>;
    private emitSelection;
    openFileSelector: () => void;
    handleFileSelection: (event: Event) => void;
    validateFile(file: File): {
        valid: boolean;
        error?: string;
    };
    removeFile: (fileId: number) => void;
    clearAllFiles: () => void;
    getFileIcon(filename: string): string;
    getTotalSize(): number;
    showSuccessMessage(msg: string): void;
    showFileErrors(errors: string[]): void;
    render(): any;
}
