import subprocess
import shutil
import os

# Buscar Node.js
node_path = shutil.which("node")

if not node_path:
    possible_paths = [
        r"C:\Program Files\nodejs\node.exe",
        r"C:\Program Files (x86)\nodejs\node.exe",
    ]
    for path in possible_paths:
        if os.path.exists(path):
            node_path = path
            break

if node_path:
    print(f"✅ Node.js encontrado: {node_path}")
    
    # Probar ejecución
    result = subprocess.run(
        [node_path, "--version"],
        capture_output=True,
        text=True
    )
    
    print(f"📦 Versión: {result.stdout.strip()}")
    print(f"Código de retorno: {result.returncode}")
else:
    print("❌ Node.js NO encontrado")